@extends('layouts.admin.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('products.index') }}">Product List</a></li>
    <li class="breadcrumb-item active">Import Products</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card box box-primary">
                <div class="card-header with-header">
                    <div class="card-title">Import Products</div>
                </div>
                <div class="card-body">
                    @if (get_auth() == 'super admin')
                        <a href="/backend/product.xlsx" class="btn btn-md btn-success"> Download Example For xls/csv File</a>
                    @else
                        <a href="/backend/product_1625339784.xlsx" class="btn btn-md btn-success"> Download Example For
                            xls/csv File</a>
                    @endif
                    <hr>
                    <form class="form-horizontal" method="post" action="{{ url('dashboard/products/import') }}"
                        enctype="multipart/form-data">
                        @csrf

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="control-label">Choose your xls/cvs file:</label>
                                <input class="form-control" type="file" name="product_import" required>
                            </div>
                        </div>

                        <div class="col-md-12 mt-3">
                            <button class="btn btn-primary">Import</button>
                        </div>
                    </form>

                </div>
            </div>
            <div class="card box box-danger mt-4">
                <div class="card-header with-border">
                    <div class="card-title">Instructions</div>
                </div>

                <div class="card-body">
                    <p><b>Follow the instructions carefully before importing the file.</b></p>
                    <p>The columns of the file should be in the following order.</p>

                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>Column No</th>
                                <th>Column Name</th>
                                <th>Description</th>
                            </tr>
                        </thead>

                        <tbody>
                            <tr>
                                <td>1</td>
                                <td><b>Product Name</b> (Required)</td>
                                <td>Name of product</td>
                            </tr>

                            <tr>
                                <td>2</td>
                                <td><b>Brand Id</b> (Required)</td>
                                <td>Name of childcategory</td>
                            </tr>

                            <tr>
                                <td>3</td>
                                <td><b>Shop Id</b> (Required)</td>
                                <td>Name of your store (Must created before importing).</td>
                            </tr>

                            <tr>
                                <td>4</td>
                                <td><b>Category Id</b> (Required)</td>
                                <td>Name of category</td>
                            </tr>

                            <tr>
                                <td>5</td>
                                <td><b>Product Description</b> (Optional)</td>
                                <td>Detail of your product</td>
                            </tr>

                            <tr>
                                <td>6</td>
                                <td><b>Price In</b> (Required)</td>
                                <td>Your Product price in currency (eg. Rs)</td>
                            </tr>

                            <tr>
                                <td>7</td>
                                <td><b>Offer Price</b> [<b>Note:</b> Leave blank if you dont want offer price.]</td>
                                <td>Your Product offer price [<b>Note:</b> Price must entered in this format eg. 50000 (No
                                    comma and character).]</td>
                            </tr>

                            <tr>
                                <td>8</td>
                                <td><b>In Stock</b> (Required)</td>
                                <td>Your Product stock</td>
                            </tr>

                            <tr>
                                <td>9</td>
                                <td><b>Discount In Percentage</b> (Optional)</td>
                                <td>Your Product discount in percentage rate (percentage)</td>
                            </tr>

                            <tr>
                                <td>10</td>
                                <td><b>Size</b> (Optional)</td>
                                <td>Your Product size</td>
                            </tr>

                            <tr>
                                <td>11</td>
                                <td><b>Color</b> (Optional)</td>
                                <td>Your Product color</td>
                            </tr>

                            <tr>
                                <td>12</td>
                                <td><b>Image</b> (Optional)</td>
                                <td>Your Product image</td>
                            </tr>

                            <tr>
                                <td>13</td>
                                <td><b>Merged</b> (Optional)</td>
                                <td>
                                    <p>Enable Merge on another product.</p>
                                    <p>(Yes = 1, No = 0)</p>
                                </td>
                            </tr>

                            <tr>
                                <td>14</td>
                                <td><b>Product Id</b> (Optional)</td>
                                <td>
                                    <p>If Enable Merge feature then (Required) for product Id.</p>
                                </td>
                            </tr>

                            <tr>
                                <td>15</td>
                                <td><b>Product Id</b> (Optional)</td>
                                <td>
                                    <p>If Enable Merge feature then (Required) for product Id.</p>
                                </td>
                            </tr>

                        </tbody>
                    </table>
                </div>
            </div>

        </div>
    </div>
@endsection
