@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('products.index') }}">Product List</a></li>
    <li class="breadcrumb-item active">Edit Product</li>
@endsection

@php
    $existingImages = json_decode($product->images, true) ?? [];
@endphp

@section('styles')
    <style media="screen">
        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 34px !important;
            background: #f2f2f2;
            border-radius: 5px;
        }

        .select2-container {
            display: block;
        }

        .dropzone {
            border: 2px dashed #aaa;
            border-radius: 10px;
            padding: 30px;
            text-align: center;
            position: relative;
            cursor: pointer;
            background-color: #f9f9f9;
            transition: border 0.3s;
        }

        .dropzone.dragover {
            border-color: #3f51b5;
            background-color: #f1f1f1;
        }

        .dropzone input[type="file"] {
            position: absolute;
            inset: 0;
            opacity: 0;
            cursor: pointer;
        }

        .image-preview-area {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            margin-top: 1rem
        }

        .image-preview-box {
            position: relative;
            width: 120px;
            height: 120px;
            border: 1px solid #ccc;
            border-radius: 8px;
        }

        .image-preview-box img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 8px
        }

        .remove-btn {
            position: absolute;
            top: 5px;
            right: 5px;
            background-color: rgba(255, 0, 0, 0.8);
            color: white;
            border: none;
            border-radius: 50%;
            width: 24px;
            height: 24px;
            line-height: 20px;
            text-align: center;
            font-size: 14px;
            cursor: pointer;
        }

        .select2-container--default .select2-selection--single .select2-selection__rendered {
            line-height: 34px !important;
            background: #f2f2f2;
            border-radius: 5px;
        }

        .select2-container {
            display: block;
        }

        #dropArea {
            width: 100%;
            padding: 50px;
            border: 2px dashed #ccc;
            text-align: center;
            cursor: pointer;
        }

        #preview {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
        }

        .image-wrapper {
            position: relative;
            width: 120px;
            height: 120px;
            border: 1px solid #ccc;
            border-radius: 8px;
        }

        .image-wrapper img {
            height: 100%;
            widows: 100%;
            border-radius: 8px;
            object-fit: cover;
        }

        .preview-image {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border: 1px solid #ccc;
        }

        .remove-btn {
            position: absolute;
            top: -8px;
            right: -8px;
            background: red;
            color: white;
            border: none;
            border-radius: 50%;
            width: 20px;
            height: 20px;
            cursor: pointer;
            font-weight: bold;
            font-size: 14px;
            line-height: 18px;
            display: flex;
            justify-content: center;
            align-items: center;
        }
    </style>
@endsection

@section('content')
    <form class="" id="houseTypeForm" method="post" action="{{ route('products.update', $product) }}"
        enctype="multipart/form-data">
        @method('PUT')
        {{ csrf_field() }}
        <div class="row g-4">
            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-header">
                        <span class="card-title">Edit Product</span>
                    </div>
                    <div class="card-body">

                        <div class="row">
                            <div class="col-md-12">
                                <div class=" row g-3">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label class="form-label">Product Name <span class="text-danger">*</span>
                                            </label>
                                            <input class="form-control" type="text" name="title" id="title"
                                                value="{{ old('title', $product->title) }}" required>
                                        </div>
                                    </div>

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">Product Slug <span
                                                    class="text-danger">*</span></label>
                                            <input class="form-control" type="text" name="slug" id="slug"
                                                value="{{ old('slug', $product->slug) }}" required>
                                        </div>
                                    </div>


                                    @include('backend.products.form.category-edit')

                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">Status </label>
                                            <select name="status" class="form-control select2">
                                                <option value="">Select One</option>
                                                <option {{ old('status', $product->status) == '1' ? 'selected' : '' }}
                                                    value="1">Active
                                                </option>
                                                <option {{ old('status', $product->status) == '0' ? 'selected' : '' }}
                                                    value="0">Disable
                                                </option>
                                            </select>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="accordion" id="detailManage">
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                Manage Detail
                            </button>
                        </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" data-bs-parent="#detailManage">
                            <div class="accordion-body">
                                <div class="row g-4">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="form-label">Summary <span class="text-danger">*</span> </label>
                                            <textarea rows="4" class="form-control" type="text" name="summary" required>{{ old('summary', $product->summary) }}</textarea>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label class="form-label">Description <span class="text-danger">*</span>
                                            </label>
                                            <textarea rows="8" class="form-control summernote" type="text" name="description" required>{{ old('description', $product->description) }}</textarea>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-3">

                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">Product Image <span class="text-danger">*</span> </label>
                                    <input class="form-control dropify" type="file" name="image"
                                        data-default-file="{{ $product->imageUrl }}"
                                        data-allowed-file-extensions="png jpg jpeg PNG JPG JPEG webp">
                                </div>
                            </div>

                            <div class="col-md-8">
                                <label class="form-label">Upload Images <span class="text-danger">*</span></label>

                                <div id="dropArea">Drag & Drop or Click to Upload</div>
                                <input type="file" id="imageInput" name="images[]" accept="image/*" style="display: none"
                                    multiple />
                                <div class="image-preview-area">

                                    <div id="preview"></div>

                                    {{-- Existing Images --}}
                                    @foreach ($existingImages as $index => $img)
                                        <div class="image-preview-box">
                                            <img src="{{ asset('frontend/images/products/' . $img) }}" alt="House Image">
                                            <button type="button" class="remove-btn"
                                                onclick="removeExistingImage(this, {{ $index }})">&times;</button>

                                            <input type="hidden" name="existing_images[]" value="{{ $img }}">
                                        </div>
                                    @endforeach
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

            @include('backend.products.form.specification')

            @can('seo-manage')
                <div class="col-md-12">
                    <div class="accordion" id="seoManage">
                        <div class="accordion-item">
                            <h2 class="accordion-header">
                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                    data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                                    Manage SEO
                                </button>
                            </h2>
                            <div id="collapseOne" class="accordion-collapse collapse" data-bs-parent="#seoManage">
                                <div class="accordion-body">
                                    <div class="row g-3">
                                        <div class="col-md-6">
                                            <label class="form-label">SEO Title </label>
                                            <input type="text" class="form-control" name="seo_title"
                                                value="{{ old('seo_title', $product->seo_title) }}">
                                        </div>

                                        <div class="col-md-6">
                                            <label class="form-label">SEO Keyword </label>
                                            <input type="text" class="form-control tagEditor" name="seo_keyword"
                                                value="{{ old('seo_keyword', $product->seo_keyword) }}">
                                        </div>

                                        <div class="col-md-12">
                                            <label class="form-label">SEO Description </label>
                                            <textarea class="form-control" name="seo_description" rows="8" cols="80">{{ old('seo_description', $product->seo_description) }}</textarea>
                                        </div>


                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            @endcan

            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-4">

                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>

                        </div>
                    </div>
                </div>
            </div>

        </div>
    </form>
@endsection

@section('scripts')
    @include('backend.products.form.script')
    <script type="text/javascript">
        $(document).on('click', '#add_slide', function() {
            $form = $(".repeat").clone().removeClass("repeat");
            $form.removeClass("d-none");
            $form.find("input,textarea").val("");
            $form.find("textarea").summernote({
                height: 200,
            });
            $("#slider_submit").before($form);
        });

        $(document).on('click', '.remove-row', function() {
            $(this).parent().remove();
        });

        const dropArea = document.getElementById('dropArea');
        const imageInput = document.getElementById('imageInput');
        const previewContainer = document.getElementById('preview');
        const form = document.getElementById('houseTypeForm');

        let selectedFiles = [];

        dropArea.addEventListener('click', () => imageInput.click());

        dropArea.addEventListener('dragover', (e) => {
            e.preventDefault();
            dropArea.style.borderColor = '#000';
        });
        dropArea.addEventListener('dragleave', () => dropArea.style.borderColor = '#ccc');
        dropArea.addEventListener('drop', (e) => {
            e.preventDefault();
            dropArea.style.borderColor = '#ccc';
            handleFiles(e.dataTransfer.files);
        });

        imageInput.addEventListener('change', () => {
            if (imageInput.files.length > 0) {
                handleFiles(imageInput.files);
                imageInput.value = ''; // allow selecting same file again
            }
        });

        function handleFiles(files) {
            [...files].forEach((file) => {
                if (!file.type.startsWith('image/')) return;

                selectedFiles.push(file);

                const reader = new FileReader();
                reader.onload = (e) => {
                    const wrapper = document.createElement('div');
                    wrapper.className = 'image-wrapper';

                    const img = document.createElement('img');
                    img.src = e.target.result;
                    img.className = 'preview-image';

                    const removeBtn = document.createElement('button');
                    removeBtn.type = 'button';
                    removeBtn.innerHTML = '&times;';
                    removeBtn.className = 'remove-btn';
                    removeBtn.onclick = () => {
                        wrapper.remove();
                        selectedFiles = selectedFiles.filter((f) => f !== file);
                    };

                    wrapper.appendChild(img);
                    wrapper.appendChild(removeBtn);
                    previewContainer.appendChild(wrapper);
                };
                reader.readAsDataURL(file);
            });
        }

        form.addEventListener('submit', function() {
            const dt = new DataTransfer();
            selectedFiles.forEach(file => dt.items.add(file));
            imageInput.files = dt.files; // attach to input[name="images[]"]
        });

        // called by inline onclick on existing images
        function removeExistingImage(btn, index) {
            const hiddenInputs = document.querySelectorAll('input[name="existing_images[]"]');
            if (hiddenInputs[index]) hiddenInputs[index].remove();
            btn.closest('.image-preview-box').remove();
        }
    </script>
@endsection
