@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('plugins.index') }}">Plugin List</a></li>
<li class="breadcrumb-item active">Edit Plugin</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default" data-collapsed="0">
            <div class="card-header">
                <div class="card-title">
                    Edit Plugin Details
                </div>
            </div>
            <div class="card-body">
                <form action="{{ route('plugins.update', $plugin) }}" class="row g-3" autocomplete="off" enctype="multipart/form-data" method="post" accept-charset="utf-8">
                    {{csrf_field()}}
                    {{ method_field('PATCH') }}
                    <div class="col-md-4 {{ $errors->has('title') ? ' has-error' : '' }}">
                        <label class="form-label">Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control" name="title" value="{{ $plugin->title }}" placeholder="Title" required>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Type <span class="text-danger">*</span></label>
                        <select class="form-select select2" name="type" required>
                            <option value="">Select One</option>
                            <option {{ (old('type', $plugin->type) == 'Header') ? 'selected' : '' }} value="Header">
                                Header Section
                            </option>
                            <option {{ (old('type', $plugin->type) == 'Body') ? 'selected' : '' }} value="Body">
                                Body Section
                            </option>
                        </select>
                    </div>

                    <div class="col-md-4">
                        <label class="form-label">Status <span class="text-danger">*</span></label>
                        <select class="form-select select2" name="status" required>
                            <option value="">Select One</option>
                            <option {{ (old('status', $plugin->status) == '1') ? 'selected' : '' }} value="1">
                                Active
                            </option>
                            <option {{ (old('status', $plugin->status) == '0') ? 'selected' : '' }} value="0">
                                Disable
                            </option>
                        </select>
                    </div>

                    <div class="col-md-12 {{ $errors->has('code') ? ' has-error' : '' }}">
                        <label class="form-label">Code <span class="text-danger">*</span></label>
                        <textarea type="text" class="form-control" rows="10" cols="50" name="code" placeholder="Your Code" required>{{ $plugin->code }}</textarea>
                    </div>

                    <div class="form-group">
                        <button type="submit" class="btn btn-info">Update</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection