@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('pages.index') }}">Page List</a></li>
<li class="breadcrumb-item active">Page Details</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <div class="card-title">
                    Page Details
                </div>
                <a href="{{ route('pages.create') }}" class="btn btn-priamry btn-sm pull-right" style="margin-top:-3px">
                    Add New
                </a>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-4">
                        <ul class="list-group">
                            <li class="list-group-item">Title: <span class="ps-3">{{ $page->title }}</span> </li>
                            <li class="list-group-item">Date: <span class="ps-3">{{ $page->created_at ? $page->created_at->format('d - M, Y') : null }}</span> </li>
                            @if ($page->seo_image)
                            <li class="list-group-item">
                                <img width="100px" src="/frontend/images/pages/{{ $page->seo_image }}" alt="">
                            </li>
                            @endif
                            @if ($page->seo_title)
                            <li class="list-group-item">SEO Title: <span class="ps-3">{{ $page->seo_title }}</span> </li>
                            @endif
                            @if ($page->seo_title)
                            <li class="list-group-item">SEO Keywords: <span class="ps-3">{{ $page->seo_keyword }}</span> </li>
                            @endif
                            @if ($page->seo_description)
                            <li class="list-group-item">SEO Description: <span class="ps-3">{{ $page->seo_description }}</span> </li>
                            @endif
                        </ul>
                    </div>
                    <div class="col-md-8">
                        <div class="card">
                            <div class="card-body">
                                @if ($page->image)
                                <img width="100px" src="/frontend/images/icons/{{ $page->image }}" alt="">
                                @endif
                                <br>
                                {!! $page->description !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection