@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('pages.index') }}">Page List</a></li>
    <li class="breadcrumb-item active">Edit Page</li>
@endsection

@section('content')
    <form action="{{ route('pages.update', $page) }}" enctype="multipart/form-data" method="post">
        @csrf
        @method('put')
        <div class="row g-4">
            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-header">
                        <div class="card-title">
                            Edit Page
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row g-3">

                            <div class="col-md-8">
                                <div class="form-group ">
                                    <label class="form-label">Name <span class="text-danger">*</span> </label>
                                    <input type="text" class="form-control" name="title" id="title"
                                        value="{{ old('title', $page->title) }}" required>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group ">
                                    <label class="form-label">Slug <span class="text-danger">*</span> </label>
                                    <input type="text" name="slug" id="slug"
                                        value="{{ old('slug', $page->slug) }}" class="form-control" required>
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group ">
                                    <label class="form-label">Slogan </label>
                                    <input type="text" name="slogan" value="{{ old('slogan', $page->slogan) }}"
                                        class="form-control">
                                </div>
                            </div>

                            <div class="col-md-4">
                                <div class="form-group ">
                                    <label class="form-label">Subtitle </label>
                                    <input type="text" name="subtitle" value="{{ old('subtitle', $page->subtitle) }}"
                                        class="form-control">
                                </div>
                            </div>


                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Description <span class="text-danger">*</span> </label>
                                    <textarea name="description" class="form-control summernote" rows="8" cols="80" required>{{ old('description', $page->description) }}
                                </textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label class="form-label">Image </label>
                                    <input type="file" readonly name="image" data-default-file="{{ $page->imageUrl }}"
                                        class="form-control dropify">
                                </div>
                                <!-- .input-item -->
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="accordion" id="seoManage">
                <div class="accordion-item">
                    <h2 class="accordion-header">
                        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                            data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                            Manage SEO
                        </button>
                    </h2>
                    <div id="collapseOne" class="accordion-collapse collapse" data-bs-parent="#seoManage">
                        <div class="accordion-body">
                            <div class="row g-3">
                                <div class="col-md-6">
                                    <label class="form-label">SEO Title </label>
                                    <input type="text" class="form-control" name="seo_title"
                                        value="{{ old('seo_title', $page->seo_title) }}">
                                </div>

                                <div class="col-md-6">
                                    <label class="form-label">SEO Keyword </label>
                                    <input type="text" class="form-control tagEditor" name="seo_keyword"
                                        value="{{ old('seo_keyword', $page->seo_keyword) }}">
                                </div>

                                <div class="col-md-12">
                                    <label class="form-label">SEO Description </label>
                                    <textarea class="form-control" name="seo_description" rows="8" cols="80">{{ old('seo_description', $page->seo_description) }}</textarea>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-3">
                            <div class="col-md-12">
                                <button type="submit" class="btn btn-primary">Submit</button>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
