@extends('layouts.backend.main')

@section('header')
<li><a href="{{ route('dashboard') }}">Dashboard</a></li>
<li class="active">Package Setting</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <div class="panel-title">
                    Package Setting
                </div>
            </div>
            <div class="panel-body">
                <form action="{{ route('packages.store') }}" method="post">
                    @csrf
                    <div class="params-panel mb-15">
                        <div class="form-group">
                            <div class="col-md-12">
                                <label class="control-label">Package Content</label>
                                <textarea type="text" class="form-control" rows="8" name="package_title">{{ get_option('package_title') }}</textarea>
                            </div>
                        </div>
                        <div class="form-group">
                            <div class="col-md-12">
                                <label class="control-label">Package Status</label>
                                <select class="form-control select2" name="package">
                                    <option value="">Select One</option>
                                    <option {{ get_option('package') == 1 ? 'selected' : ''  }} value="1">Active</option>
                                    <option {{ get_option('package') == 0 ? 'selected' : ''  }} value="0">Disable</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="form-group">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-primary mt-2">Update</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection