@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('orders.index')}}">All Order</a></li>
<li class="breadcrumb-item active">Order List</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Order Details
                </span>
            </div>
            <div class="card-body row">
                <h4>User/Shipping Details</h4>
                <ul class="list-group col-md-4">
                    <li class="list-group-item">
                        <strong>Ordered By</strong> : {{ $order->user->name }}
                    </li>

                    <li class="list-group-item">
                        <strong>Created at</strong> : {{ $order->created_at->toDateString() }}
                    </li>
                    <li class="list-group-item">
                        <strong>Shipping Details</strong>
                    </li>
                    <?php $shippingdetails = $order->user->shipping ?>
                    <li class=" list-group-item">
                        <strong>State/zone</strong> : {{$shippingdetails->state_or_zone}}
                    </li>
                    <li class=" list-group-item">
                        <strong>Town/City</strong> : {{$shippingdetails->town_or_city}}
                    </li>
                    <li class=" list-group-item">
                        <strong>Street</strong> : {{$shippingdetails->street}}
                    </li>
                    <li class=" list-group-item">
                        <strong>Phone Number</strong> : {{$shippingdetails->phone_number}}
                    </li>
                    @if(isset($shippingdetails->company_name))
                        <li class=" list-group-item">
                            <strong>Company Name</strong> : {{$shippingdetails->company_name}}
                        </li>
                        @endif
                        @if(isset($shippingdetails->postal_or_zipcode))
                            <li class=" list-group-item">
                                <strong>Postal or Zipcode</strong> : {{$shippingdetails->postal_or_zipcode}}
                            </li>
                            @endif
                            @if(isset($shippingdetails->notes))
                                <li class=" list-group-item">
                                    <strong>Notes</strong> : {{$shippingdetails->notes}}
                                </li>
                                @endif
                                <li class="list-group-item">
                                    <a href="{{route('challan.index', $order)}}" class="btn btn-success  btn-sm" target="_blank">Challan</a>
                                    <a href="{{route('generate_PDF', $order)}}" class="btn btn-primary btn-sm" target="_blank">Generate PDF</a>
                                </li>
                </ul>
                <div class="col-md-8">
                    <h4>Product Details</h4>
                    <div class="table responsive">
                        <table class="table table-striped">
                            <thead>
                                <th>S.No</th>
                                <th>Product Name</th>
                                <th>Qty</th>
                                <th>size</th>
                                <th>Color</th>
                                <th>Total price</th>
                                <th>Status</th>
                            </thead>
                            <tbody>
                                <?php $i=0; $grandtotal = 0; ?>
                                @foreach($items as $item)
                                <?php $i++;?>
                                <tr>
                                    <td>{{$i}}</td>
                                    <td>{{$item->name}}</td>
                                    <td>{{$item->pivot->qty}}</td>
                                    <td>{{$item->pivot->size}}</td>
                                    <td>{{$item->pivot->color}}</td>
                                    <td>{{$item->pivot->total}}</td>
                                    <td><label class="badge badge-primary">{{$item->pivot->status}}</label></td>
                                </tr>
                                <?php $grandtotal = $grandtotal + $item->pivot->total ?>
                                @endforeach
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                    <td><strong>Grand Total</strong></td>
                                    <td><strong>{{$grandtotal}}</strong></td>
                                    <td></td>
                                </tr>
                            </tbody>
                        </table>
                        @if(!empty($statuses))
                        <form class="form-horizontal" method="post" action="{{route('change-status', $order)}}">
                            @csrf
                            <div class="form-group">
                                <label class="col-md-4 control-label">Mark As:</label>
                                <div class="col-md-6">
                                    <select name="status" class="form-control">
                                        @foreach($statuses as $status)
                                        <option value="{{$status}}">{{$status}}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <button type="submit" class="btn btn-primary btn-sm">Done</button>
                            </div>
                        </form>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>


</div>
@endsection