@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item active">All Orders</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Orders
                </span>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-hover table-bordered" id="example1">
                    <thead>
                        <th>S.No</th>
                        <th> Ordered By</th>
                        <th>Total items</th>
                        <th>Payment type</th>
                        <th>Ordered Time</th>
                        <th>Action</th>
                    </thead>
                    <tbody>
                        <?php $i = 0;?>
                        @foreach($orders as $order)
                        <?php $i++; ?>
                        @can('viewAny', $order)
                        <tr>
                            <td>{{$i}}</td>
                            <td>{{$order->user->name}}</td>
                            <td>{{$order->total_items}}</td>
                            <td>{{$order->payment_type}}</td>
                            <td>{{$order->created_at->diffForHumans()}}</td>
                            <td>
                                <a href="{{route('orders.show', $order)}}" class="text-success fs-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" width="24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                </a>
                                <a href="{{route('orders.destroy', $order)}}" class="text-danger fs-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19.4 22.169" fill="currentColor" width="16">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.4">
                                            <path data-name="Rectangle 2" d="M8.238.7h2.923a2 2 0 012 2v.769h0-6.923 0V2.7a2 2 0 012-2z"></path>
                                            <path data-name="Line 1" d="M.7 3.469h18"></path>
                                            <path data-name="Path 77" d="M14.649 21.469h-9.9a1.385 1.385 0 01-1.38-1.279L2.085 3.469h15.231L16.029 20.19a1.385 1.385 0 01-1.38 1.279z"></path>
                                            <path data-name="Line 2" d="M7.623 6.238V18.7"></path>
                                            <path data-name="Line 3" d="M11.777 6.238V18.7"></path>
                                        </g>
                                    </svg>
                                </a>
                            </td>
                        </tr>
                        @endcan
                        @endforeach


                    </tbody>

                </table>
            </div>
        </div>
    </div>
</div>
@endsection