@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('banners.index')}}">Main Banner</a></li>
<li class="breadcrumb-item"><a href="{{route('navsliders.index')}}">Nav Slider List</a></li>
<li class="breadcrumb-item active">Create A NavSlider</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Create A NavSlider</span>
            </div>
            <div class="card-body">
                <form class="form-horizontal" method="post" action="{{route('navsliders.store')}}" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group row mb-3">
                        <label class="col-md-4 control-label">Title:</label>
                        <div class="col-md-6">
                            <input class="form-control" type="text" name="title" placeholder="Title" required>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-4 control-label">Where to Display:</label>
                        <div class="col-md-6">
                            <select name="place" class="form-control">
                                <option value="nav_slider">Navbar Slider</option>
                                <option value="product_category">Product Categories</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-4 control-label">Show on page</label>
                        <div class="col-md-6">
                            <input type="radio" name="status" value="0"><label>No</label><br>

                            <input type="radio" name="status" value="1" checked><label>Yes</label><br>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-md-4 control-label">Choose an Image:</label>
                        <div class="col-md-6">
                            <input class="form-control" type="file" name="navslider_image" required>
                        </div>
                    </div>
                    <div class="form-group row">
                        <label class="col-md-12 control-label">Choose Categories:</label>
                        <div class="col-md-12 row mb-3">
                            @foreach($categories as $category)
                            <div class="col-md-4">
                                <input type="radio" id="category" name="category_id" value="{{$category->id}}"> <strong>{{$loop->iteration}}. {{$category->name}}</strong>

                                @foreach($category->childs as $subcat)
                                    <div class="col-md-12 ms-3">
                                        <input type="radio" id="category" name="category_id" value="{{$subcat->id}}"> <label class="control-label">{{$subcat->name}}</label>

                                        @foreach($subcat->childs as $subcat)
                                            <div class="col-md-12">
                                                <input type="radio" id="category" name="category_id" value="{{$subcat->id}}"> <label class="control-label">{{$subcat->name}}</label>
                                            </div>
                                            @endforeach
                                    </div>
                                    @endforeach
                            </div>
                            @endforeach
                        </div>
                        <hr>

                    </div>
                    <div class="col-md-offset-4">
                        <button class="btn btn-primary">Add Nav Slider</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection