@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"> <a href="{{ route('buy_methods.index') }}">Buy Method List</a> </li>
<li class="breadcrumb-item active">Buy Method Details</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Buy Method Details
                </div>
            </div>
            <div class="card-body">
                <ul class="list-group col-md-6">
                    @if ($buyMethod->image)
                    <li> <img src="/frontend/images/methods/{{ $buyMethod->image }}" alt=""> </li>
                    @endif

                    <li class="list-group-item"> <strong>Title : </strong> {{ $buyMethod->title }} </li>
                    <li class="list-group-item"> <strong>Summary : </strong> {{ $buyMethod->summary }} </li>
                    <li class="list-group-item"> <strong>Status : </strong>
                        @if ($buyMethod->status == 0)
                        <span class="text-success">Active</span>
                        @else
                        <span class="text-warning">Disable</span>
                        @endif
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection