@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"> <a href="{{ route('positions.index') }}">Position</a> </li>
    <li class="breadcrumb-item active">Edit Position</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        Edit Position
                    </div>
                </div>
                <div class="card-body">
                    <form class="row g-3" action="{{ route('positions.update', $position) }}" method="post">
                        @csrf
                        @method('put')

                        <div class="col-md-6">
                            <div class="form-group">
                                <label class="form-label">Title <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control" name="title"
                                    value="{{ old('title', $position->title) }}" required />
                            </div>
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">Status <span class="text-danger">*</span></label>
                            <select class="form-select select2" name="status" required>
                                <option value="">Select One</option>
                                <option {{ old('status', $position->status) == '1' ? 'selected' : '' }} value="1">
                                    Active
                                </option>
                                <option {{ old('status', $position->status) == '0' ? 'selected' : '' }} value="0">
                                    Disable
                                </option>
                            </select>
                        </div>
                        <div class="form-group">
                            <button type="submit" class="btn btn-success">Submit</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
