@extends('layouts.backend.main')

@section('header')
<li><a href="{{ route('dashboard') }}">Dashboard</a></li>
<li class="active">KYC Form</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="panel panel-default">
            <div class="panel-heading">
                <span class="panel-title">KYC Form</span>
            </div>
            <div class="panel-body">
                <table class="table table-bordered" id="example1">
                    <thead>
                        <th>#</th>
                        <th>Name</th>
                        <th>Gender</th>
                        <th>Contact</th>
                        <th>Address</th>
                        <th>Company Name</th>
                        <th>Joining Date</th>
                        <th>Status</th>
                        <th>Action</th>
                    </thead>
                    <tbody>
                        @foreach ($customers as $key => $customer)
                        <tr>
                            <td>{{ ++$key }}</td>
                            <td>{{ $customer->name }}</td>
                            <td>{{ $customer->gender }}</td>
                            <td>{{ $customer->contact_no }}</td>
                            <td>{{ $customer->temporary_address }}</td>
                            <td>{{ $customer->company_name }}</td>
                            <td>{{ $customer->joining_date }}</td>
                            <td>
                                @if ($customer->status == 0)
                                <label class="label label-warning">Pending</label>
                                @endif
                                @if ($customer->status == 1)
                                <label class="label label-success">Accepted</label>
                                @endif
                                @if ($customer->status == 2)
                                <label class="label label-danger">Rejected</label>
                                @endif
                            </td>
                            <td>
                                @can ('kyc-show')
                                <a href="{{route('kycs.show', $customer)}}" class="btn btn-info btn-sm">
                                    <i class="fa fa-eye"></i>
                                </a>
                                @endcan
                                @can('kyc-edit')
                                <a onClick="event.preventDefault(); document.getElementById('check-accept').submit();" class="btn btn-success btn-sm"><i class=" fa fa-check"></i></a>
                                <form style="display: none;" id="check-accept" action="{{ route('kycs.check', $customer) }}" method="post">
                                    @csrf
                                </form>
                                @endcan
                                @can ('kyc-delete')
                                <a href="{{ route('kycs.edit', $customer) }}" class="btn btn-sm btn-danger ajax-modal"><i class="fa fa-close"></i> </a>
                                @endcan
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>

    </div>
</div>
@endsection