@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('joblists.index')}}">Job List</a></li>
<li class="breadcrumb-item active">View Job</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="panel-title">
                    Job Details
                </span>
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <ul class="list-group col-md-6">
                        <li class="list-group-item">
                            <strong>Job Title : </strong>
                            <span class="ps-3">{{ $joblist->title }}</span>
                        </li>
                        <li class="list-group-item">
                            <strong>Type : </strong>
                            <span class="ps-3">{{ $joblist->time }}</span>
                        </li>
                        <li class="list-group-item">
                            <strong>Salary : </strong>
                            <span class="ps-3">{{ $joblist->salary }}</span>
                        </li>
                        <li class="list-group-item">
                            <strong>Education : </strong>
                            <span class="ps-3">{{ $joblist->education }}</span>
                        </li>
                        <li class="list-group-item">
                            <strong>Experince : </strong>
                            <span class="ps-3">{{ $joblist->experince }}</span>
                        </li>
                        <li class="list-group-item">
                            <strong>No. of Vacancy : </strong>
                            <span class="ps-3">{{ $joblist->no_of_vacancy }}</span>
                        </li>
                        <li class="list-group-item">
                            <strong>Status : </strong>
                            <span class="ps-3">{!! $joblist->status == 1 ? '<span class="label label-success">Active</span>' : '<span class="label label-primary">Disable</span>' !!}</span>
                        </li>
                    </ul>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Description
                                </div>
                            </div>
                            <div class="card-body">
                                {!! $joblist->description !!}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection