@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"> <a href="{{ route('galleries.index') }}">Gallery List</a> </li>
    <li class="breadcrumb-item active">View Gallery</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <div class="card-title">
                        Gallery Details
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <ul class="list-group">
                                <li class="list-group-item text-center">
                                    <img style="height: 120px; object-fit: contain" src="{{ $gallery->imageUrl }}"
                                        alt="">
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Title : </strong> {{ $gallery->title }}
                                </li>

                                <li class="list-group-item">
                                    <strong class="pe-3">Status : </strong>
                                    @if ($gallery->status == 1)
                                        <label class="text-success p-2">Active</label>
                                    @else
                                        <label class="text-warning p-2">Disable</label>
                                    @endif
                                </li>
                                <li class="list-group-item">
                                    <strong class="pe-3">Created At:</strong>
                                    {{ $gallery?->created_at?->format('d M, Y') }}
                                </li>

                            </ul>
                        </div>

                        <div class="col-md-6">
                            @if (count(json_decode($gallery->images)))
                                <div class="row g-4">
                                    @foreach (json_decode($gallery->images) as $item)
                                        <div class="col-md-6">
                                            <img class="w-100" src="/frontend/images/galleries/{{ $item }}"
                                                alt="">
                                        </div>
                                    @endforeach
                                </div>
                            @endif
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
