@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item active">Gallery List</li>
@endsection


@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span class="card-title">
                        Gallery
                    </span>
                    <div class="d-flex">
                        @can('gallery-create')
                            <a href="{{ route('galleries.create') }}" class="btn btn-secondary">
                                Add New
                            </a>
                        @endcan

                    </div>
                </div>
                <div class="card-body table-responsive">
                    <table class="table table-hover table-bordered data-table" id="example1">
                        <thead>
                            <th width="60px">S.No</th>
                            <th>Name</th>
                            <th width="80px">Status</th>
                            <th width="120px">Action</th>
                        </thead>
                        <tbody>
                            <?php $i = 0; ?>
                            @foreach ($galleries as $key => $item)
                                <?php $i++; ?>
                                <tr>
                                    <td>{{ $i }}</td>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <img style="width: 60px;object-fit: contain" src="{{ $item->imageUrl }}"
                                                alt="">
                                            <div class="ps-3">
                                                <div class="">
                                                    {{ $item->title }}
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="form-check form-switch">
                                            <input type="checkbox" role="switch" class="form-check-input"
                                                id="status{{ $key }}"
                                                onchange="saveData(event, '{{ $item->slug }}')"
                                                {{ $item->status == 1 ? 'checked' : '' }}>
                                            <label class="form-check-label" for="stock{{ $key }}"></label>
                                        </div>
                                    </td>
                                    <td>
                                        @can('gallery-edit')
                                            <a href="{{ route('galleries.edit', $item) }}" class="text-secondary fs-4"
                                                title="Edit Event Details">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20.547 20.299"
                                                    fill="currentColor" width="16">
                                                    <g stroke="currentColor" stroke-width=".4">
                                                        <path data-name="Path 78"
                                                            d="M18.659 12.688a.5.5 0 00-.5.5v4.423a1.5 1.5 0 01-1.494 1.494H2.691A1.5 1.5 0 011.2 17.609V4.629a1.5 1.5 0 011.494-1.494h4.419a.5.5 0 100-1H2.691A2.493 2.493 0 00.2 4.629v12.98A2.493 2.493 0 002.691 20.1h13.976a2.493 2.493 0 002.491-2.491v-4.423a.5.5 0 00-.5-.5zm0 0">
                                                        </path>
                                                        <path data-name="Path 79"
                                                            d="M18.96.856a2.241 2.241 0 00-3.17 0L6.899 9.739a.5.5 0 00-.128.219l-1.169 4.219a.5.5 0 00.613.613l4.219-1.169a.5.5 0 00.219-.128l8.886-8.887a2.244 2.244 0 000-3.17zm-10.971 9.21l7.273-7.273 2.346 2.346-7.273 7.273zm-.469.94l1.879 1.875-2.592.718zm11.32-7.1l-.528.528-2.346-2.345.528-.528a1.245 1.245 0 011.761 0l.585.584a1.247 1.247 0 010 1.761zm0 0">
                                                        </path>
                                                    </g>
                                                </svg>
                                            </a>
                                        @endcan

                                        <a href="{{ route('galleries.show', $item) }}" class="text-success fs-4"
                                            title="View  Details">
                                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                                stroke="currentColor" width="20">
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                                    d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z">
                                                </path>
                                            </svg>
                                        </a>

                                        @can('gallery-delete')
                                            <a type="button" class="text-danger fs-4" data-bs-toggle="modal"
                                                data-bs-target="#deleteModal{{ $item->id }}">
                                                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19.4 22.169"
                                                    fill="currentColor" width="16">
                                                    <g fill="none" stroke="currentColor" stroke-linecap="round"
                                                        stroke-linejoin="round" stroke-width="1.4">
                                                        <path data-name="Rectangle 2"
                                                            d="M8.238.7h2.923a2 2 0 012 2v.769h0-6.923 0V2.7a2 2 0 012-2z">
                                                        </path>
                                                        <path data-name="Line 1" d="M.7 3.469h18"></path>
                                                        <path data-name="Path 77"
                                                            d="M14.649 21.469h-9.9a1.385 1.385 0 01-1.38-1.279L2.085 3.469h15.231L16.029 20.19a1.385 1.385 0 01-1.38 1.279z">
                                                        </path>
                                                        <path data-name="Line 2" d="M7.623 6.238V18.7"></path>
                                                        <path data-name="Line 3" d="M11.777 6.238V18.7"></path>
                                                    </g>
                                                </svg>
                                            </a>
                                            <div id="deleteModal{{ $item->id }}" class="delete-modal modal fade"
                                                role="dialog">
                                                <!-- Delete Modal -->
                                                <div class="modal-dialog modal-sm">
                                                    <div class="modal-content">
                                                        <div class="modal-body text-center">
                                                            <h4 class="modal-heading">Are You Sure ?</h4>
                                                            <p>Do you really want to delete these records? This process cannot
                                                                be undone.</p>
                                                        </div>
                                                        <div class="modal-footer">
                                                            {!! Form::open(['method' => 'DELETE', 'route' => ['galleries.destroy', $item]]) !!}
                                                            {!! Form::reset('No', ['class' => 'btn btn-gray', 'data-bs-dismiss' => 'modal']) !!}
                                                            {!! Form::submit('Yes', ['class' => 'btn btn-danger']) !!}
                                                            {!! Form::close() !!}
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endcan
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>

                    </table>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('scripts')
    <script type="text/javascript">
        function saveData(event, primaryid) {
            // console.log($('#' + event.target.id).val());
            var _token = $('input[name=_token]').val();
            // console.log(fieldname);
            // console.log(primaryid);
            $.ajax({
                method: "POST",
                url: '/dashboard/events/quickedit/' + primaryid,
                data: {
                    _token: _token,
                },
                beforeSend: function() {
                    $('#preloader').css('display', 'block');
                },
                success: function(data) {
                    $('#preloader').css('display', 'none');
                    if (data.result == 'success') {
                        Command: toastr["success"](data.message)
                    }
                    else {
                        Command: toastr["error"](data.message)
                    }
                }
            });
        }
    </script>
@endsection
