@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"> <a href="{{ route('faqs.index') }}"> Faq List </a> </li>
<li class="breadcrumb-item active">Show Faq</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Show Faq</span>
            </div>
            <div class="card-body">
                <ul class="list-group">
                    <li class="list-group-item"> <strong class="pe-3">Question :</strong> {{ $faq->question }}</li>
                    <li class="list-group-item"> <strong class="pe-3">Type:</strong> {{ $faq->type->title }}</li>
                    <li class="list-group-item"> <strong class="pe-3">Status :</strong>
                        @if ($faq->status == 0)
                        <span class="text-success">Active</span>
                        @else
                        <span class="text-warning">Disable</span>
                        @endif
                    </li>
                    <li class="list-group-item">
                        {{ $faq->answer }}
                    </li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection