@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"> <a href="{{ route('faq_requests.index') }}">Request List</a> </li>
<li class="breadcrumb-item active">Reply Faq</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Reply Question
                </div>
            </div>
            <div class="card-body">
                <form class="row g-3" action="{{ route('faq_requests.update', $faq) }}" method="post">
                    @csrf
                    @method('put')

                    <div class="col-md-12">
                        <div class=" row g-3">
                            <div class="col-md-8">
                                <div class="row g-3">
                                    <div class="form-group col-md-12">
                                        <label class="form-label">Question <span class="text-danger">*</span> </label>
                                        <input class="form-control" type="text" name="question" value="{{ old('question', $faq->question) }}" required>
                                    </div>

                                    <div class="form-group col-md-12">
                                        <label class="form-label">Answer <span class="text-danger">*</span> </label>
                                        <textarea class="form-control" name="answer" rows="8" cols="80">{{ old('answer', $faq->answer) }}</textarea>
                                    </div>
                                </div>

                            </div>
                            <div class="col-md-4">
                                <div class="row g-3">
                                    <div class="form-group col-md-12">
                                        <label class="form-label">Type <span class="text-danger">*</span> </label>
                                        <select class="form-select select2" name="faq_type">
                                            <option value="">Select One</option>
                                            @foreach (get_faq_types() as $key => $type)
                                            <option {{ (old('faq_type', $faq->faq_type_id) == $type->id) ? 'selected' : '' }} value="{{ $type->id }}">
                                                {{ $type->title }}
                                            </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label class="form-label">Status <span class="text-danger">*</span> </label>
                                        <select class="form-select select2" name="status">
                                            <option value="">Select One</option>
                                            <option {{ (old('status', $faq->status) == '1') ? 'selected' : '' }} value="1">Active</option>
                                            <option {{ (old('status', $faq->status) == '0') ? 'selected' : '' }} value="0">Disable</option>
                                        </select>
                                    </div>
                                </div>
                            </div>



                        </div>
                    </div>
                    <div class="col-md-0">
                        <button class="btn btn-primary">Submit</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection