@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"> <a href="{{ route('dealer_requests.index') }}">Dealer Request</a> </li>
<li class="breadcrumb-item">View Dealer Profile</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Dealer Profile
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <ul class="list-group">
                            <li class="list-group-item"> <strong class="pe-3">Full Name : </strong> {{ $dealer->name }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Company Name : </strong> {{ $dealer->company_name }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Address : </strong> {{ $dealer->address }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Email Address : </strong> {{ $dealer->email }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Phone No. : </strong> {{ $dealer->phone }} </li>
                            <li class="list-group-item"> <strong class="pe-3">PAN No. : </strong> {{ $dealer->pan_no }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Applied On : </strong> {{ $dealer->created_at ? $dealer->created_at->format('d M, Y') : null }} </li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    PAN File
                                </div>
                            </div>
                            <div class="card-body">
                                <img src="/frontend/images/dealers/{{ $dealer->pan_file }}" class="w-100" alt="">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection