@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"> <a href="{{ route('customer_enquiries.index') }}">Customer Enquiry</a> </li>
<li class="breadcrumb-item">View Customer Enquiry Details</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title">
                    Customer Enquiry Profile
                </div>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <ul class="list-group">
                            <li class="list-group-item"> <strong class="pe-3">Full Name : </strong> {{ $customerEnquiry->name }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Address : </strong> {{ $customerEnquiry->address }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Email Address : </strong> {{ $customerEnquiry->email }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Phone No. : </strong> {{ $customerEnquiry->phone }} </li>
                            <li class="list-group-item"> <strong class="pe-3">Applied On : </strong> {{ $customerEnquiry->created_at ? $customerEnquiry->created_at->format('d M, Y') : null }} </li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <div class="card">
                            <div class="card-header">
                                <div class="card-title">
                                    Query
                                </div>
                            </div>
                            <div class="card-body">
                                {{ $customerEnquiry->message }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection