@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('contact_persons.index') }}">Contact Peron List</a></li>
<li class="breadcrumb-item active">View Contact Person Details</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <div class="card-title">
                    View Contact Person Details
                </div>
            </div>
            <div class="card-body row">
                <div class="col-md-6">
                    <div class="card card-primary">
                        <div class="card-header">
                            <div class="card-title">
                                Personal Information
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered">
                                <tr>
                                    <td>User Id</td>
                                    <td>{{ $contactPerson->user_name }}</td>
                                </tr>
                                <tr>
                                    <td>Full Name</td>
                                    <td>{{ $contactPerson->contact_person }}</td>
                                </tr>
                                <tr>
                                    <td>Date of Birth</td>
                                    <td>{{ $contactPerson->date_of_birth }}</td>
                                </tr>
                                <tr>
                                    <td>Address</td>
                                    <td>{{ $contactPerson->address }}</td>
                                </tr>
                                <tr>
                                    <td>Email</td>
                                    <td>{{ $contactPerson->email }}</td>
                                </tr>
                                <tr>
                                    <td>Phone Number</td>
                                    <td>{{ $contactPerson->phone_number }}</td>
                                </tr>
                                <tr>
                                    <td>Landline Number</td>
                                    <td>{{ $contactPerson->landline_number }}</td>
                                </tr>
                                <tr>
                                    <td>Company Name</td>
                                    <td>{{ $contactPerson->company_name }}</td>
                                </tr>
                                <tr>
                                    <td>PAN No</td>
                                    <td>{{ $contactPerson->pan_no }}</td>
                                </tr>
                                @if ($contactPerson->position)
                                <tr>
                                    <td>Position</td>
                                    <td>{{ $contactPerson->position }}</td>
                                </tr>
                                @endif
                            </table>
                        </div>
                    </div>
                </div>
                {{-- <div class="col-md-6">
                    <div class="card card-primary">
                        <div class="card-header">
                            <div class="card-title">
                                Quotation List
                            </div>
                        </div>
                        <div class="card-body">
                            <table class="table table-bordered">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>Quotation Id</th>
                                        <th>Total Items</th>
                                        <th>Ordered Time</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($contactPerson->quotations as $key => $quotation)
                                    <tr>
                                        <td>{{ ++$key }}</td>
                <td>{{ $quotation->contact_people ? $quotation->contact_people->contact_person : '' }}</td>
                <td>{{ $quotation->total_items }}</td>
                <td>{{ $quotation->created_at->diffForHumans() }}</td>
                <td>
                    @if ($quotation->status == 'Pending')
                    <label class="label label-warning">{{ $quotation->status }}</label>
                    @endif
                    @if ($quotation->status == 'Approved')
                    <label class="label label-success">{{ $quotation->status }}</label>
                    @endif
                    @if ($quotation->status == 'Rejected')
                    <label class="label label-danger">{{ $quotation->status }}</label>
                    @endif
                </td>
                <td>
                    @can ('quotation-show')
                    <a href="{{route('quotations.show', $quotation)}}" class="btn btn-info btn-sm">
                        <i class="fa fa-eye"></i>
                    </a>
                    @endcan
                </td>
                </tr>
                @endforeach
                </tbody>
                </table>
            </div>
        </div>
    </div> --}}
</div>
</div>
</div>
</div>
@endsection