@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item active">Contact Request</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Contact Request
                </span>
            </div>
            <div class="card-body table-responsive">
                <table class="table table-hover table-bordered data-table">
                    <thead>
                        <th>S.No</th>
                        <th>Name</th>
                        <th>Phone</th>
                        <th>Sent Date</th>
                        <th>Action</th>
                    </thead>
                    <tbody>
                        @foreach($contacts as $contact)
                        <tr>
                            <td>{{$loop->iteration}}</td>
                            <td>{{$contact->name}}</td>
                            <td>{{$contact->phone_number}}</td>
                            <td>{{$contact->created_at->format('F j, Y')}}</td>
                            <td>


                                <a href="{{route('contact_forms.show', $contact)}}" class="text-success fs-4">
                                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor" width="20">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                                    </svg>
                                </a>

                                @can ('contact-us-delete')
                                <a type="button" class="text-danger fs-4" data-bs-toggle="modal" data-bs-target="#deleteModal{{$contact->id}}">
                                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 19.4 22.169" fill="currentColor" width="16">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="1.4">
                                            <path data-name="Rectangle 2" d="M8.238.7h2.923a2 2 0 012 2v.769h0-6.923 0V2.7a2 2 0 012-2z"></path>
                                            <path data-name="Line 1" d="M.7 3.469h18"></path>
                                            <path data-name="Path 77" d="M14.649 21.469h-9.9a1.385 1.385 0 01-1.38-1.279L2.085 3.469h15.231L16.029 20.19a1.385 1.385 0 01-1.38 1.279z"></path>
                                            <path data-name="Line 2" d="M7.623 6.238V18.7"></path>
                                            <path data-name="Line 3" d="M11.777 6.238V18.7"></path>
                                        </g>
                                    </svg>
                                </a>
                                <div id="deleteModal{{$contact->id}}" class="delete-modal modal fade" role="dialog">
                                    <!-- Delete Modal -->
                                    <div class="modal-dialog modal-sm">
                                        <div class="modal-content">
                                            <div class="modal-body text-center">
                                                <h4 class="modal-heading">Are You Sure ?</h4>
                                                <p>Do you really want to delete these records? This process cannot be undone.</p>
                                            </div>
                                            <div class="modal-footer">
                                                {!! Form::open(['method' => 'DELETE', 'route' => ['contact_forms.destroy', $contact]]) !!}
                                                {!! Form::reset("No", ['class' => 'btn btn-gray', 'data-bs-dismiss' => 'modal']) !!}
                                                {!! Form::submit("Yes", ['class' => 'btn btn-danger']) !!}
                                                {!! Form::close() !!}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endcan
                            </td>
                        </tr>

                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
