@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('certificates.index') }}">Certificate List</a></li>
    <li class="breadcrumb-item active">View Certificate</li>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-default">
                <div class="card-header">
                    <span class="card-title">
                        Certificate Details
                    </span>
                    @can('certificate-create')
                        <a href="{{ route('certificates.create') }}" class="btn btn-secondary">Add Certificate</a>
                    @endcan
                </div>
                <div class="card-body row">
                    <div class="col-md-6  ">
                        <div class="card card-primary">
                            <div class="card-header">
                                Image
                            </div>
                            <div class="card-body">
                                <img class="img-responsive product_image" src="{{ $certificate->imageUrl }}" width="100%"
                                    height="auto">
                            </div>
                        </div>
                    </div>

                    <ul class="list-group col-md-6">
                        <li class="list-group-item">
                            <strong>Title</strong> : {{ $certificate->title }}
                        </li>
                        <li class="list-group-item">
                            <strong>Status</strong> :
                            @if ($certificate->status == 1)
                                <label class="text-success p-2">Active</label>
                            @else
                                <label class="text-warning p-2">Disable</label>
                            @endif
                        </li>

                        <li class="list-group-item">
                            <strong>Created</strong> :
                            {{ $certificate->created_at ? $certificate->created_at->format('d M, Y') : '' }}
                        </li>
                        <li class="list-group-item">
                            <strong>Created by</strong> : {{ $certificate->user ? $certificate->user->name : '' }}
                        </li>
                    </ul>
                    @can('certificate-edit')
                        <a href="{{ route('certificates.edit', $certificate) }}" class="btn btn-primary mt-3">
                            Edit This Certificate
                        </a>
                    @endcan
                </div>
            </div>
        </div>


    </div>
@endsection
