@extends('layouts.backend.main')

@section('header')
    <li class="breadcrumb-item"><a href="{{ route('certificates.index') }}">Certificate</a></li>
    <li class="breadcrumb-item active">Edit Certificate</li>
@endsection

@section('content')
    <form action="{{ route('certificates.update', $certificate) }}" enctype="multipart/form-data" method="post">
        @csrf
        @method('put')
        <div class="row g-4">
            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-header">
                        <div class="card-title">
                            Edit Certificate
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-md-6">
                                <label class="form-label">Title <span class="text-danger">*</span> </label>
                                <input type="text" class="form-control" name="title"
                                    value="{{ old('title', $certificate->title) }}">
                            </div>
                            <div class="col-md-4">
                                <label class="form-label">Status <span class="text-danger">*</span></label>
                                <select class="form-select select2" name="status" required>
                                    <option value="">Select One</option>
                                    <option {{ old('status', $certificate->status) == '1' ? 'selected' : '' }}
                                        value="1">Active</option>
                                    <option {{ old('status', $certificate->status) == '0' ? 'selected' : '' }}
                                        value="0">Disable</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group col-lg-4">
                                <label class="form-label">Chooser an Image:</label>
                                <input class="form-control dropify" type="file" name="image"
                                    data-default-file="{{ $certificate->imageUrl }}">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="card card-default">
                    <div class="card-body">
                        <div class="row">
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary" name="button">Submit</button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </form>
@endsection
