@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('categories.index')}}">Category List</a></li>
<li class="breadcrumb-item active">View Category</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">
                    Category Details
                </span>
                @can('category-create')
                <a href="{{ route('categories.create') }}" class="btn btn-secondary btn-sm">Add Category</a>
                @endcan
            </div>
            <div class="card-body">
                <div class="row g-3">
                    <div class="list-group col-md-6">
                        <div class="card panel box box-primary">
                            <div class="card-header">
                                <h6 class="card-title">Child categories</h6>
                            </div>
                            <div class="card-body">
                                <h4>{{$category->name}}</h4>
                                @if(count($category->childs))
                                    @foreach($category->childs as $child)
                                        <ul class="list-group">
                                            <li class="list-group-item">
                                                <span>{{$child->title}}</span>
                                            </li>
                                            @if(count($child->childs))
                                                @include('backend.categories.child', ['childs'=> $child->childs])
                                                @endif
                                        </ul>
                                        @endforeach
                                        @endif
                            </div>
                        </div>
                    </div>

                    <ul class="list-group col-md-6">
                        <li class="list-group-item">
                            <strong>Name</strong> : {{ $category->title }}
                        </li>
                        <li class="list-group-item">
                            <strong>Created by</strong> : {{ $category->user->name }}
                        </li>
                        @if ($category->image)
                        <li class="list-group-item">
                            <img src="/frontend/images/categories/{{$category->image}}" height="150px" width="150px">
                        </li>
                        @endif
                    </ul>
                    <div class="col-lg-12">
                        @can('category-edit')
                        <a href="{{route('categories.edit', $category)}}" class="btn btn-primary"> Edit This Category</a>
                        @endcan
                    </div>

                </div>
            </div>
        </div>
    </div>


</div>
@endsection