@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('brands.index') }}">Brand List</a></li>
<li class="breadcrumb-item active">Edit Brand Form</li>
@endsection

@section('content')
<form enctype="multipart/form-data" action="{{ route('brands.update', $brand) }}" method="post">
    @csrf
    @method('put')
    <div class="row g-4">
        <div class="col-lg-12 g-3">
            <div class="card">
                <div class="card-header">
                    <div class="card-title mb-0">Edit Brand Form</div>
                    <!-- .step-fields -->
                </div>
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-8">
                            <div class="form-group">
                                <label class="form-label">
                                    Brand Name <span class="text-danger">*</span>
                                </label>
                                <input class="form-control" type="text" name="title" value="{{ old('title', $brand->title) }}">
                            </div>
                            <!-- .input-item -->
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">
                                    Slug <span class="text-danger">*</span>
                                </label>
                                <input class="form-control" type="text" name="slug" value="{{ old('slug', $brand->slug) }}">
                            </div>
                            <!-- .input-item -->
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Status <span class="text-danger">*</span> </label>
                                <select class="form-select select2" name="status" required>
                                    <option value="">Select One</option>
                                    <option {{ (old('status', $brand->status) == '1') ? 'selected' : '' }} value="1">Active</option>
                                    <option {{ (old('status', $brand->status) == '0') ? 'selected' : '' }} value="0">Disable</option>
                                </select>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
            <!-- .card -->
        </div>

        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="row g-3">

                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Brand Image <span class="text-danger">*</span></label>
                                <input type="file" readonly name="image" class="form-control dropify" data-default-file="/frontend/images/brands/{{ $brand->image }}" required>
                            </div>
                            <!-- .input-item -->
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="accordion" id="seoManage">
            <div class="accordion-item">
                <h2 class="accordion-header">
                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="false" aria-controls="collapseOne">
                        Manage SEO
                    </button>
                </h2>
                <div id="collapseOne" class="accordion-collapse collapse" data-bs-parent="#seoManage">
                    <div class="accordion-body">
                        <div class="row g-3">
                            <div class="col-md-6">
                                <label class="form-label">SEO Title </label>
                                <input type="text" class="form-control" name="seo_title" value="{{ old('seo_title', $brand->seo_title) }}">
                            </div>

                            <div class="col-md-6">
                                <label class="form-label">SEO Keyword </label>
                                <input type="text" class="form-control tagEditor" name="seo_keyword" value="{{ old('seo_keyword', $brand->seo_keyword) }}">
                            </div>

                            <div class="col-md-12">
                                <label class="form-label">SEO Description </label>
                                <textarea class="form-control" name="seo_description" rows="8" cols="80">{{ old('seo_description', $brand->seo_description) }}</textarea>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-12">
            <div class="card">
                <div class="card-body">
                    <div class="row g-3">
                        <div class="col-md-12">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </div>
</form>
@endsection

@section('scripts')
<script src="/admin/plugins/popup/popup.js" charset="utf-8"></script>

<script type="text/javascript">
    $('.dropify').dropify();

    function getName(val) {
        document.getElementById("image").value = document.getElementById(`myCheckbox${val}`).src;
    }

    function openPage(pageName, elmnt, color) {
        var i, tabcontent, tablinks;
        tabcontent = document.getElementsByClassName("tabcontainer");
        for (i = 0; i < tabcontent.length; i++) {
            tabcontent[i].style.display = "none";
        }
        tablinks = document.getElementsByClassName("tablink");
        for (i = 0; i < tablinks.length; i++) {
            tablinks[i].style.backgroundColor = "";
        }
        document.getElementById(pageName).style.display = "block";
        elmnt.style.backgroundColor = color;
    }

    // Get the element with id="defaultOpen" and click on it
    document.getElementById("defaultOpen").click();
</script>
@endsection