@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('brands.index')}}">Brand List</a></li>
<li class="breadcrumb-item active">Add Brand</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-8">
        <div class="card card-default">
            <div class="card-header">
                <span class="panel-title">Add Brand</span>
            </div>
            <div class="card-body">
                <div class="params-panel">
                    <form class="row g-3" method="post" action="{{route('brands.store')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Name:</label>
                                <input class="form-control" type="text" name="name" value="{{ old('name') }}" placeholder="Brand Name" required>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Url Link:</label>
                                <input class="form-control" type="text" name="url_address" value="{{ old('url_address') }}" placeholder="Brand Link">
                            </div>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="control-label">Chooser an Image:</label>
                                <input class="form-control dropify" type="file" name="brand_image" required>
                                <p>The image should be less than 500 KB and less than 250X250 dimension</p>
                            </div>

                        </div>
                        <div class="col-md-12">
                            <button class="btn btn-primary">Add Brand</button>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection