@extends('layouts.backend.main')

@section('header')
<li class="breadcrumb-item"><a href="{{ route('blog_categories.index') }}">Category List</a></li>
<li class="breadcrumb-item active">Category Form</li>
@endsection

@section('content')
<div class="row">
    <div class="col-lg-12">
        <div class="card">
            <div class="card-header">
                <div class="card-title mb-0">Category Form</div>
                <!-- .step-fields -->
            </div>
            <div class="card-body">
                <form enctype="multipart/form-data" action="{{ route('blog_categories.update', $category) }}" method="post">
                    @csrf
                    @method('put')
                    <div class="row g-3">
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">
                                    Category Name <span class="text-danger">*</span>
                                </label>
                                <input class="form-control" type="text" name="title" value="{{ old('title', $category->title) }}">
                            </div>
                            <!-- .input-item -->
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">
                                    Slug <span class="text-danger">*</span>
                                </label>
                                <input class="form-control" type="text" name="slug" value="{{ old('slug', $category->slug) }}">
                            </div>
                            <!-- .input-item -->
                        </div>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label class="form-label">Status <span class="text-danger">*</span> </label>
                                <select class="form-control select2" name="status" required>
                                    <option value="">Select One</option>
                                    <option {{ (old('status') == '1') ? 'selected' : '' }} value="1">
                                        Active
                                    </option>
                                    <option {{ (old('status') == '0') ? 'selected' : '' }} value="0">
                                        Disable
                                    </option>
                                </select>
                            </div>
                        </div>

                        <div class="col-md-12">
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </div>

                    </div>
                </form>
            </div>
        </div>
        <!-- .card -->
    </div>
</div>
@endsection

@section('scripts')
<script type="text/javascript">
    $('.dropify').dropify();

    var subcategory_id = $('select[name=subcategory_id]').val();
    var childsubcategory_id = $('select[name=childsubcategory_id]').val();
    if (subcategory_id) {
        $(".student-group").fadeIn();
    }
    if (childsubcategory_id) {
        $(".student-group1").fadeIn();
    }

    function getCategory(val) {
        var _token = $('input[name=_token]').val();
        $.ajax({
            type: "POST",
            url: "{{ url('dashboard/groups/categories') }}",
            data: {
                _token: _token,
                group_id: val
            },
            beforeSend: function() {
                $("#preloader").css("display", "block");
            },
            success: function(data) {
                $("#preloader").css("display", "none");
                $(".student-group").fadeOut();
                $(".student-group1").fadeOut();
                $('select[name=parent_category]').html(data);
                $('select[name=subcategory_id]').val(null);
                $('select[name=childsubcategory_id]').val(null);
            }
        });
    }

    function getData(val) {
        var _token = $('input[name=_token]').val();
        var category_id = $('select[name=parent_category]').val();
        $.ajax({
            type: "POST",
            url: "{{ url('dashboard/categories/getCategory') }}",
            data: {
                _token: _token,
                category_id: category_id
            },
            beforeSend: function() {
                $("#preloader").css("display", "block");
            },
            success: function(data) {
                $("#preloader").css("display", "none");
                $(".student-group").fadeIn();
                $(".student-group1").fadeOut();
                $('select[name=subcategory_id]').html(data);
                $('select[name=childsubcategory_id]').val(null);
            }
        });

    }

    function getSubCategory(val) {
        var _token = $('input[name=_token]').val();
        var subcategory_id = $('select[name=subcategory_id]').val();
        $.ajax({
            type: "POST",
            url: "{{ url('dashboard/categories/getCategory') }}",
            data: {
                _token: _token,
                category_id: subcategory_id
            },
            beforeSend: function() {
                $("#preloader").css("display", "block");
            },
            success: function(data) {
                $("#preloader").css("display", "none");
                $(".student-group1").fadeIn();
                $('select[name=childsubcategory_id]').html(data);
            }
        });

    }
</script>
@endsection