@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('banners.index')}}">Main Banner</a></li>
<li class="breadcrumb-item active">View Banner</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span>
                    Banner Details
                </span>
                <a href="{{ route('banners.create') }}" class="btn btn-secondary btn-sm">Add Banner</a>
            </div>
            <div class="card-body row">
                <div class="col-md-6  ">
                    <div class="card card-primary">
                        <div class="card-header">
                            Image
                        </div>
                        <div class="box-body">
                            <img class="img-responsive product_image" src="{{ $banner->getMedia('banner_images')->first()->getUrl() }}" width="100%" height="auto">
                        </div>
                    </div>
                </div>

                <ul class="list-group col-md-6">
                    <li class="list-group-item">
                        <strong>Title</strong> : {{ $banner->title }}
                    </li>
                    <li class="list-group-item">
                        <strong>Place</strong> : {{ $banner->place }}
                    </li>


                    <li class="list-group-item">
                        <strong>Display on slider</strong> :
                        @if($banner->status==1)
                            Yes
                            @else
                            No
                            @endif
                    </li>

                    <li class="list-group-item">
                        <strong>Created</strong> : {{ $banner->created_at->diffForHumans() }}
                    </li>
                    <li class="list-group-item">
                        <strong>Created by</strong> : {{ $banner->createdBy->name }}
                    </li>
                </ul>

                <a href="{{route('banners.edit', $banner)}}" class="btn btn-primary mt-3"> Edit This Banner
                </a>

            </div>
        </div>
    </div>


</div>
@endsection