@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('banners.index')}}">Main Banner</a></li>
<li class="breadcrumb-item active">Edit Banner</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Edit Banner</span>
            </div>
            <div class="card-body">
                <div class="params-panel">
                    <form class="form-horizontal" method="post" action="{{route('banners.update', $banner)}}" enctype="multipart/form-data">
                        @method('PUT')
                        @csrf
                        <div class="form-group row mb-3">
                            <label class="col-md-4 control-label">Title:</label>
                            <div class="col-md-6">
                                <input class="form-control" type="text" name="title" value="{{$banner->title}}" required>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-md-4 control-label">Choose a Place:</label>
                            <div class="col-md-6">
                                <select name="place" class="form-control">
                                    <option value="Right slider" {{$banner->place =="Right slider" ? 'selected': ''}}>Right Side</option>
                                    <option value="Left slider" {{$banner->place =="Left slider"? 'selected': ''}}>Left Side</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-md-4 control-label">Show on page</label>
                            <div class="col-md-6">
                                <input type="radio" name="status" value="0" {{$banner->status ==0 ? 'checked': ''}}><label>No</label><br>

                                <input type="radio" name="status" value="1" {{$banner->status ==1 ? 'checked': ''}}><label>Yes</label><br>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-md-4 control-label">Choose an Image:</label>
                            <div class="col-md-6">
                                <input class="form-control" type="file" name="banner_image">
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-md-12 control-label">Choose Categories:</label>
                            <div class="col-md-12 row">
                                @foreach($categories as $category)
                                <div class="col-md-4">
                                    <input type="radio" id="category" name="category_id" value="{{$category->id}}" {{$banner->category_id==$category->id?'checked':''}}> <strong>{{$loop->iteration}}. {{$category->name}}</strong>

                                    @foreach($category->childs as $subcat)
                                        <div class="col-md-12 show-subcategory ms-3">
                                            <input type="radio" id="category" name="category_id" value="{{$subcat->id}}" {{$banner->category_id==$subcat->id?'checked':''}}> <label class="control-label">{{$subcat->name}}</label>

                                            @foreach($subcat->childs as $subcat)
                                                <div class="col-md-12">
                                                    <input type="radio" id="category" name="category_id" value="{{$subcat->id}}" {{$banner->category_id==$subcat->id?'checked':''}}> <label class="control-label">{{$subcat->name}}</label>
                                                </div>
                                                @endforeach
                                        </div>
                                        @endforeach
                                </div>
                                @endforeach
                                <hr>

                            </div>

                        </div>
                        <div class="col-md-offset-4">
                            <button class="btn btn-primary">Update Banner</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection