@extends('layouts.admin.main')

@section('header')
<li class="breadcrumb-item"><a href="{{route('banners.index')}}">Main Banner</a></li>
<li class="breadcrumb-item active">Create A Banner</li>
@endsection

@section('content')
<div class="row">
    <div class="col-md-12">
        <div class="card card-default">
            <div class="card-header">
                <span class="card-title">Create A Banner</span>
            </div>
            <div class="card-body">
                <div class="params-panel">
                    <form class="form-horizontal" method="post" action="{{route('banners.store')}}" enctype="multipart/form-data">
                        @csrf
                        <div class="form-group row mb-3">
                            <label class="col-md-4 control-label">Title:</label>
                            <div class="col-md-6">
                                <input class="form-control" type="text" name="title" placeholder="Title" required>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-md-4 control-label">Choose a Place:</label>
                            <div class="col-md-6">
                                <select name="place" class="form-control">
                                    <option value="Right slider">Right Side</option>
                                    <option value="Left slider">Left Side</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-md-4 control-label">Show on page</label>
                            <div class="col-md-6">
                                <input type="radio" name="status" value="0"><label>No</label><br>

                                <input type="radio" name="status" value="1" checked><label>Yes</label><br>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-md-4 control-label">Choose an Image:</label>
                            <div class="col-md-6">
                                <input class="form-control" type="file" name="banner_image" required>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-md-12 control-label">Choose Categories:</label>
                            <div class="col-md-12 row">
                                @foreach($categories as $category)
                                <div class="col-md-4">
                                    <input type="radio" id="category" name="category_id" value="{{$category->id}}"> <strong>{{$loop->iteration}}. {{$category->name}}</strong>

                                    @foreach($category->childs as $subcat)
                                        <div class="col-md-12 ms-3">
                                            <input type="radio" id="category" name="category_id" value="{{$subcat->id}}"> <label class="control-label">{{$subcat->name}}</label>

                                            @foreach($subcat->childs as $subcat)
                                                <div class="col-md-12">
                                                    <input type="radio" id="category" name="category_id" value="{{$subcat->id}}"> <label class="control-label">{{$subcat->name}}</label>
                                                </div>
                                                @endforeach
                                        </div>
                                        @endforeach
                                </div>
                                @endforeach
                            </div>
                            <hr>
                        </div>
                        <div class="col-md-offset-4">
                            <button class="btn btn-primary">Add Banner</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection