@extends('layouts.frontend.main')

@section('title', 'Login')

@section('headerTitle', 'Login')

@section('header')
    <li class="breadcrumb-item active">Login</li>
@endsection

@section('meta')
    <meta name="keywords"
        content="{{ get_seo_page('login')->seo_keyword ? get_seo_page('login')->seo_keyword : get_option('seo_meta_keywords') }}">
    <meta name="description"
        content="{{ get_seo_page('login')->seo_description ? get_seo_page('login')->seo_description : get_option('seo_meta_description') }}">
    <link rel="canonical" href="{{ request()->url() }}" />
    <!-- Twitter -->
    <meta name="twitter:card" content="summary">
    <meta name="twitter:title"
        content="{{ get_seo_page('login')->seo_title ? get_seo_page('login')->seo_title : 'Login - ' . get_option('title') }}">
    <meta name="twitter:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta name="twitter:description"
        content="{{ get_seo_page('login')->seo_description ? get_seo_page('login')->seo_description : get_option('seo_meta_description') }}">

    <!-- Facebook -->
    <meta property="og:url" content="{{ request()->url() }}">
    <meta property="og:title"
        content="{{ get_seo_page('login')->seo_title ? get_seo_page('login')->seo_title : 'Login - ' . get_option('title') }}">
    <meta name="og:description"
        content="{{ get_seo_page('login')->seo_description ? get_seo_page('login')->seo_description : get_option('seo_meta_description') }}">
    <meta property="og:type" content="article">
    <meta property="og:image" content="{{ asset('frontend/images/' . get_option('image')) }}">
    <meta property="og:image:type" content="image/png">
    <meta property="og:image:width" content="1000">
    <meta property="og:image:height" content="500">
@endsection

@section('content')
    <div class="page-contact-us">

        <div class="container">
            <div class="login__container">
                <div class="row justify-content-center">
                    <div class="col-md-6">
                        <div class="dealer__card">

                            <div class="dealer__card-body contact-three__btn-box  py-5">
                                <form method="POST" class="contact-form" action="{{ route('login') }}">
                                    @csrf

                                    <div class="col-md-12 mb-3">
                                        <label for="email" class="form-label">{{ __('Email Address') }}</label>
                                        <input id="email" type="email"
                                            class="form-control @error('email') is-invalid @enderror" name="email"
                                            value="{{ old('email') }}" required autocomplete="email" autofocus>

                                    </div>

                                    <div class="col-md-12 mb-3">
                                        <label for="password" class="form-label ">{{ __('Password') }}</label>

                                        <input id="password" type="password"
                                            class="form-control @error('password') is-invalid @enderror" name="password"
                                            required autocomplete="current-password">


                                    </div>

                                    <div class="col-md-12 ">
                                        @if (Route::has('password.request'))
                                            <a class="ps-0 btn-link mb-3 d-inline-block"
                                                href="{{ route('password.request') }}">
                                                {{ __('Forgot Your Password?') }}
                                            </a>
                                        @endif
                                    </div>

                                    <div class="col-md-12 mb-0">
                                        <button type="submit" class="thm-btn border-0 px-5 contact-three__btn">
                                            {{ __('Login') }}
                                        </button>


                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
