import React from "react";
import Offcanvas from "react-bootstrap/Offcanvas";
import MainCategory from "./MainCategory";
import FilterBrand from "./FilterBrand";

const MobileFilter = ({
    show,
    handleClose,
    loading,
    categories,
    handleChange,
    brands,
    handleChangeBrand,
}) => {
    return (
        <>
            <Offcanvas
                className="store__widget"
                show={show}
                onHide={handleClose}
            >
                <Offcanvas.Header closeButton>
                    <Offcanvas.Title>Filter</Offcanvas.Title>
                </Offcanvas.Header>
                <Offcanvas.Body>
                    <FilterBrand
                        loading={loading}
                        brands={brands}
                        handleChange={handleChangeBrand}
                    />
                    <MainCategory
                        loading={loading}
                        categories={categories}
                        handleChange={handleChange}
                    />
                </Offcanvas.Body>
            </Offcanvas>
        </>
    );
};

export default MobileFilter;
