import React from "react";
import FilterTitle from "./FilterTitle";

const FilterWeight = ({ loading, sizes, handleChange }) => {
    return (
        <>
            <div className="service-catagery-list wow fadeInUp">
                <h3 className="widget_title">Shop by Weight</h3>
                <div className="store__widget-body">
                    <ul className="ps-0">
                        {!loading ? (
                            sizes.length > 0 &&
                            sizes.map((size, index) => (
                                <li key={index}>
                                    <FilterTitle
                                        item={size}
                                        type="size"
                                        handleChange={handleChange}
                                    />
                                </li>
                            ))
                        ) : (
                            <>Loading</>
                        )}
                    </ul>
                </div>
            </div>
        </>
    );
};

export default FilterWeight;
