import React from "react";
import Checkbox from "@material-ui/core/Checkbox";
import { makeStyles } from "@material-ui/core/styles";
import FormControlLabel from "@material-ui/core/FormControlLabel";

const useStyles = makeStyles({
    root: {
        "&$checked": {
            color: "#000",
        },
    },
    checked: {},
    wrap: {
        width: "100%",
        display: "flex",
        flexDirection: "row-reverse",
        justifyContent: "space-between",
        alignItems: "center",
        marginLeft: 0,
    },
    label: {
        fontSize: "15px",
        paddingLeft: "0",
        color: "#000",
    },
});

const FilterTitle = ({ item, index, handleChange, type }) => {
    const classes = useStyles();

    return (
        <>
            <FormControlLabel
                classes={{
                    label: classes.label,
                    root: classes.wrap,
                }}
                key={index}
                control={
                    <Checkbox
                        classes={{
                            checked: classes.checked,
                            root: classes.root,
                        }}
                        size="small"
                        checked={item.checked}
                        onChange={() => handleChange(item.id, type)}
                        inputProps={{
                            "aria-label": "checkbox with small size",
                        }}
                    />
                }
                label={item.title}
                // label={`${ category.title } (${category.products})`}
            />
        </>
    );
};

export default FilterTitle;
