import React from "react";
import { FormControl } from "react-bootstrap";

const FilterPrice = ({ max, min, setMin, setMax, handlePrice }) => {
    return (
        <>
            <div class="widget widget_categories">
                <h3 class="widget_title">Shop by Price</h3>
                <div class="store__widget-body">
                    <form className="price-filter">
                        <FormControl
                            type="number"
                            min={0}
                            onChange={(event) => setMin(event.target.value)}
                            value={min}
                            className="price-input"
                            placeholder="Min"
                        />
                        <FormControl
                            type="number"
                            min={0}
                            className="price-input"
                            onChange={(event) => setMax(event.target.value)}
                            value={max}
                            placeholder="Max"
                        />
                    </form>
                    <div className="mt-3">
                        <button
                            type="button"
                            onClick={handlePrice}
                            className="th-btn star-btn"
                        >
                            Search
                        </button>
                    </div>
                </div>
            </div>
        </>
    );
};

export default FilterPrice;
