import React from "react";
import FilterTitle from "./FilterTitle";

const FilterBrand = ({ loading, brands, handleChange }) => {
    return (
        <>
            <div className="shop-category product__sidebar-single wow fadeInUp">
                <h3 className="product__sidebar-title">Shop by Brand</h3>
                <ul className="list-unstyled ps-0">
                    {!loading ? (
                        brands.length > 0 &&
                        brands.map((brand, index) => (
                            <li key={index}>
                                <FilterTitle
                                    item={brand}
                                    type="brand"
                                    handleChange={handleChange}
                                />
                            </li>
                        ))
                    ) : (
                        <>Loading</>
                    )}
                </ul>
            </div>
        </>
    );
};

export default FilterBrand;
