import React from "react";
import { Col, Row } from "react-bootstrap";
import Pagination from "react-js-pagination";

const ProductList = ({
    loading,
    products,
    totalProducts,
    currentPage,
    perPages,
    getData,
}) => {
    return (
        <>
            {!loading ? (
                <div className="product__items">
                    {products?.length > 0 ? (
                        <Row className="g-4">
                            {products?.map((product, index) => (
                                <Col xl={3} lg={3} md={6} key={index}>
                                    <div className="product__all-single">
                                        <div className="service-item product-content wow fadeInUp">
                                            <a
                                                href={`/products/${product.slug}`}
                                                data-cursor-text="View"
                                                className="product__all-img"
                                            >
                                                <img
                                                    src={product?.image}
                                                    alt={product.title}
                                                    height="100%"
                                                    width="100%"
                                                />
                                                <img
                                                    src={product?.image}
                                                    alt={product.title}
                                                    height="100%"
                                                    width="100%"
                                                />
                                            </a>
                                            <div className="product__all-content">
                                                <h3 className="product__all-title">
                                                    <a
                                                        href={`/products/${product.slug}`}
                                                    >
                                                        {product.title}
                                                    </a>
                                                </h3>
                                                <p className="text-muted mt-2">
                                                    {product?.category}
                                                </p>
                                            </div>
                                        </div>
                                    </div>
                                </Col>
                            ))}
                        </Row>
                    ) : (
                        <>No Product Found</>
                    )}
                </div>
            ) : (
                <>Loading</>
            )}

            {totalProducts > 6 && (
                <div className="blog-list__pagination">
                    <Pagination
                        activePage={currentPage}
                        totalItemsCount={totalProducts}
                        itemsCountPerPage={perPages}
                        onChange={(pageNumber) => getData(pageNumber)}
                        itemClass="count"
                        linkClass="page-link"
                        innerClass="pg-pagination list-unstyled"
                        firstPageText={
                            <i className="fa-regular fa-chevrons-left"></i>
                        }
                        lastPageText={
                            <i className="fa-regular fa-chevrons-right"></i>
                        }
                        prevPageText={<i className="far fa-arrow-left"></i>}
                        nextPageText={<i className="far fa-arrow-right"></i>}
                    />
                </div>
            )}
        </>
    );
};

export default ProductList;
