import React from "react";

const FilterList = ({ handleShow, sort, setSort }) => {
    return (
        <>
            <div className="col-12">
                <div
                    className="products-toolbar flex items-center mb-8"
                    id="products-toolbar"
                >
                    <div className="filter-section">
                        <div className="products-toolbar__filter">
                            <button
                                type="button"
                                id="filter-toggle"
                                className="products-toolbar__filter-btn desktop__filter flex justify-between items-center font-bold"
                            >
                                <span className=" md:block">Filter</span>
                                <svg
                                    width="20"
                                    height="20"
                                    viewBox="0 0 20 20"
                                    strokeWidth="1.25"
                                    stroke="currentColor"
                                    aria-hidden="true"
                                >
                                    <path
                                        strokeLinecap="round"
                                        strokeLinejoin="round"
                                        d="M1 6h18M1 14h18"
                                    ></path>
                                    <circle cx="7" cy="6" r="3"></circle>
                                    <circle cx="13" cy="14" r="3"></circle>
                                </svg>
                            </button>
                            <button
                                type="button"
                                onClick={handleShow}
                                className="products-toolbar__filter-btn mobile__filter flex justify-between items-center font-bold"
                            >
                                <svg
                                    width="20"
                                    height="20"
                                    viewBox="0 0 20 20"
                                    strokeWidth="1.25"
                                    stroke="currentColor"
                                    aria-hidden="true"
                                >
                                    <path
                                        strokeLinecap="round"
                                        strokeLinejoin="round"
                                        d="M1 6h18M1 14h18"
                                    ></path>
                                    <circle cx="7" cy="6" r="3"></circle>
                                    <circle cx="13" cy="14" r="3"></circle>
                                </svg>
                            </button>
                        </div>
                    </div>

                    <div className="view-wrap">
                        <div className="product__showing-sort">
                            <div className="select-box">
                                <select
                                    className="wide"
                                    defaultValue={sort}
                                    onChange={(event) =>
                                        setSort(event.target.value)
                                    }
                                >
                                    <option data-display="Sort by">
                                        Sort by
                                    </option>
                                    <option value="asc"> Low to High</option>
                                    <option value="desc"> High to Low</option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </>
    );
};

export default FilterList;
