DROP TABLE IF EXISTS about_pages;

CREATE TABLE `about_pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `summary` longtext NOT NULL,
  `image_first` varchar(255) NOT NULL,
  `image_second` varchar(255) NOT NULL,
  `image_third` varchar(255) NOT NULL,
  `image_fourth` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `about_pages_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO about_pages VALUES('1','11b0a7cf-c30c-4f3f-9d3d-c5b3d81d464b','Buy Now For Diabetic Product','Shop now at Diabliss for diabetes-friendly Low GI Foods products that support your health and taste great.','6f3ac71a-2b75-4024-a1b9-dc8a1098785a.webp','22c46a11-1cec-4760-ae54-851448d9fea1.webp','4986995b-bc91-4336-b7cb-746d755de6d8.webp','8db34039-f72d-451c-b74b-2f2f7ccb900e.webp','2023-05-17 08:35:33','2023-06-08 06:15:24');



DROP TABLE IF EXISTS applications;

CREATE TABLE `applications` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `date_of_birth` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `cv` varchar(255) NOT NULL,
  `gender` varchar(255) NOT NULL,
  `qualification` varchar(255) NOT NULL,
  `experience` varchar(255) NOT NULL,
  `message` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `applications_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS blog_categories;

CREATE TABLE `blog_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) DEFAULT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(25) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO blog_categories VALUES('2','herbal-water','1','Herbal Water','1','2023-05-12 04:40:29','2023-05-25 14:26:53');
INSERT INTO blog_categories VALUES('3','low-glycemic-index-gi-diet','1','Low GI','1','2023-05-12 04:41:25','2023-05-25 14:14:49');
INSERT INTO blog_categories VALUES('4','others','1','Others','1','2023-05-25 14:29:11','2023-05-26 12:39:57');



DROP TABLE IF EXISTS blogs;

CREATE TABLE `blogs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `category_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `description` longtext DEFAULT NULL,
  `summary` longtext DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_image` varchar(255) DEFAULT NULL,
  `seo_keyword` longtext DEFAULT NULL,
  `seo_description` longtext DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `count_views` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `blogs_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO blogs VALUES('3','a-sweet-deal-for-diabetic-friendly-delights-diabliss-products-unlease-the-power-of-healthful-indualnce','1','3','A Sweet Deal for Diabetic-Friendly Delights :  Diabliss Products Unleash the Power of Healthful Indulgence','<p></p><p style=\"text-align: justify; \"><span style=\"font-family: Verdana;\">Welcome to the world of Diabliss Products, where sweetness meets health. Diabliss is a brand committed to providing a range of innovative, diabetic-friendly products that allow you to indulge in the goodness of sweetness without compromising your well-being. In this blog, we will delve into the unique qualities and benefits of Diabliss products that make them a must-have for anyone looking to manage their blood sugar levels and embrace a healthier lifestyle.&nbsp;</span><span style=\"text-align: var(--bs-body-text-align);\"><font face=\"Verdana\">Improve your overall health and well-being with our comprehensive resources for diabetes management through nutrition.</font></span></p><p style=\"text-align: justify;\"><span style=\"font-family: Verdana;\"><br></span></p><h5 style=\"text-align: justify;\"><span style=\"font-family: Verdana;\">Diabliss - Redefining Sweetness:</span></h5><p style=\"text-align: justify;\"><span style=\"color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">Diabliss Products which are&nbsp;</span><span style=\"text-align: var(--bs-body-text-align);\">diabetes-friendly </span><span style=\"color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">are meticulously crafted to bring you the perfect balance of taste and health. What sets them apart is the innovative inclusion of herbal extracts, which naturally regulate blood sugar levels. Unlike regular sweeteners that cause sudden spikes and crashes in blood sugar, Diabliss sweeteners provide sustained energy, making them ideal for individuals with diabetes or those seeking to reduce their sugar intake.</span></p><p style=\"text-align: justify;\"><span style=\"color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\"><br></span></p><p></p><h5 style=\"text-align: justify;\"><span style=\"text-align: var(--bs-body-text-align);\"><span style=\"font-family: Verdana;\">The Power of Diabliss Ingredients:</span></span></h5><div style=\"text-align: justify;\"><span style=\"color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">Diabliss sweeteners are made using a unique blend of natural ingredients that offer numerous health benefits. Let\'s explore some of these key components:</span></div><p></p><p></p><h6 style=\"text-align: justify;\"><b>Cane Sugar with Herbal Extracts:</b></h6><p style=\"text-align: justify;\">Diabliss sweeteners are derived from high-quality cane sugar infused with a carefully curated blend of herbal extracts, including fenugreek, cinnamon, black pepper, and ginger. These extracts are known for their anti-diabetic properties and help regulate blood glucose levels.</p><p style=\"text-align: justify;\"><br></p><h6 style=\"text-align: justify;\"><font face=\"Verdana\"><b>Low Glycemic Index</b></font></h6><p style=\"text-align: justify;\"><span style=\"font-family: Verdana;\">&nbsp;Diabliss diabetes friendly products have a low glycemic index, meaning they have a minimal impact on blood sugar levels. This makes them a healthier alternative to traditional sweeteners, helping you maintain stable blood sugar levels and reducing the risk of diabetic complications.&nbsp;</span><span style=\"text-align: var(--bs-body-text-align);\"><font face=\"Verdana\">Explore delicious diabetic recipes, learn about balanced meal plans, and find expert advice on maintaining stable blood sugar levels.</font></span></p><p style=\"text-align: justify;\"><span style=\"font-family: Verdana;\"><br></span></p><h6 style=\"text-align: justify;\"><b>Antioxidant-Rich</b></h6><p style=\"text-align: justify;\"><span style=\"font-family: Verdana;\">Diabliss sweeteners contain natural antioxidants that help combat oxidative stress, reduce inflammation, and boost overall immunity. These properties make Diabliss products an excellent addition to your daily routine for promoting optimal health.</span></p><p style=\"text-align: justify;\"><span style=\"font-family: Verdana;\"><br></span></p><p></p><h5 style=\"text-align: justify;\">Diabliss Product Range</h5><p style=\"text-align: justify;\"><span style=\"font-family: Verdana;\">Diabliss offers a diverse range of products to satisfy your sweet tooth while prioritizing your health:</span></p><p></p><h6 style=\"text-align: justify;\"><span style=\"font-size: 1rem; color: var(--bs-card-color); text-align: var(--bs-body-text-align);\"><b>Diabliss Diabetic-Friendly Sweeteners</b></span><br></h6><p></p><p style=\"text-align: justify;\">Replace refined sugar in your favorite beverages, desserts, and recipes with Diabliss sweeteners for a guilt-free indulgence.</p><p style=\"text-align: justify;\"><br></p><h6 style=\"text-align: justify;\"><b>&nbsp;Diabliss Herbal Tea</b></h6><p style=\"text-align: justify;\">Enjoy the aromatic flavors and therapeutic benefits of Diabliss Herbal Tea, which combines the goodness of herbal extracts with a rich taste.</p><p style=\"text-align: justify;\"><br></p><h6 style=\"text-align: justify;\"><b>Diabliss Snacks</b></h6><p style=\"text-align: justify;\">Treat yourself to a wide selection of diabetic-friendly snacks, including cookies, chocolates, and nuts, all carefully crafted to provide a delicious and healthy snacking experience.</p><p style=\"text-align: justify;\"><br></p><h5 style=\"text-align: justify;\">Embrace a Healthier Lifestyle with Diabliss</h5><p style=\"text-align: justify;\">By incorporating Diabliss Products into your daily routine, you can enjoy the following benefits:</p><p style=\"text-align: justify;\"><br></p><h6 style=\"text-align: justify;\"><b>Blood Sugar Management</b></h6><p style=\"text-align: justify;\">Diabliss products are designed to help maintain stable blood sugar levels, making them a valuable addition to the diet of individuals with diabetes or pre-diabetic conditions.</p><p style=\"text-align: justify;\"><br></p><h6 style=\"text-align: justify;\"><b>Weight Management</b></h6><p style=\"text-align: justify;\">Diabliss diet can be an effective tool in managing weight by reducing the intake of high-calorie sugar while still satisfying your sweet cravings.</p><p style=\"text-align: justify;\"><br></p><p></p><h6 style=\"text-align: justify;\"><span style=\"font-family: Verdana;\"><b>Improved Overall Health</b></span></h6><p style=\"text-align: justify;\"><span style=\"font-family: Verdana;\">The natural ingredients and antioxidants in Diabliss</span><span style=\"text-align: var(--bs-body-text-align);\"><font face=\"Verdana\">&nbsp;diabetes diet&nbsp;</font></span><span style=\"font-family: Verdana; color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">&nbsp;contribute to enhanced well-being, better digestion, and improved immune function.&nbsp;</span></p><p style=\"text-align: justify;\"><span style=\"font-family: Verdana;\"><br></span></p><p style=\"text-align: justify;\"><span style=\"font-family: Verdana;\"><br></span></p><p style=\"text-align: justify;\"><span style=\"font-family: Verdana; text-align: var(--bs-body-text-align); color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight);\">Diabliss Products bring together the best of taste and&nbsp;</span><span style=\"font-family: Verdana; text-align: var(--bs-body-text-align); color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight);\">healthy eating for diabetics</span><span style=\"font-family: Verdana; text-align: var(--bs-body-text-align); color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight);\">&nbsp;to provide you with a revolutionary range of diabetic-friendly alternatives. Whether you\'re looking to manage your blood sugar levels, embrace a healthier lifestyle, or simply enjoy a guilt-free indulgence, Diabliss is here to support you every step of the way.&nbsp;</span><span style=\"font-family: Verdana; text-align: var(--bs-body-text-align); color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight);\">Improve your overall health and well-being with our comprehensive resources for diabetes management through nutrition.&nbsp;</span><span style=\"font-family: Verdana; text-align: var(--bs-body-text-align); color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight);\">Try Diabliss&nbsp;</span><span style=\"font-family: Verdana; text-align: var(--bs-body-text-align); color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight);\">diabetes diet&nbsp;</span><span style=\"font-family: Verdana; text-align: var(--bs-body-text-align); color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight);\">today and experience the sweetness of life without compromising your well-being!</span><br></p><p style=\"text-align: justify;\"><br></p><p style=\"box-sizing: border-box; margin: 0px 0px 1rem; padding: 0px; font-family: Poppins, sans-serif;\"></p><p style=\"text-align: justify;\"><br></p><p></p>','Are you ready to embark on a journey where sweetness meets wellness? Look no further than Diabliss Products, a brand that redefines indulgence by infusing it with healthful benefits.','75223028-14c4-42ac-bf2d-34019349d545.webp','','','','','1','2023-05-25 15:01:53','2023-08-10 21:24:16','66');
INSERT INTO blogs VALUES('4','discover-diabliss-products-:-diabetic-friendly-delights-now-at-bhatbhateni-super-market','1','3','Discover Diabliss Products: Diabetic-Friendly Delights Now Available at Bhatbhateni Super Market','<p><br></p><blockquote style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><p><span style=\"font-size: 12pt; font-family: Helvetica; color: black;\">For individuals with
diabetes or those seeking healthier alternatives to manage their blood sugar
levels, finding suitable products can often be a challenge. However, thanks to
the introduction of Diabliss products at Bhatbhateni Super Market,
diabetic-friendly options are now conveniently accessible. In this blog post,
we will explore the range of Diabliss products available, highlighting their
unique features and benefits for individuals conscious of their sugar intake.</span></p></blockquote><blockquote style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><blockquote style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><p><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\"><o:p>&nbsp;</o:p></span></p></blockquote></blockquote><blockquote style=\"text-align: left;\"><span style=\"color: rgb(0, 0, 0); font-family: Helvetica; text-align: justify; background-color: rgb(156, 198, 239);\">Diabliss, Revolutionizing Diabetic-Friendly Products and Bringing Sweetness into your life</span></blockquote><blockquote style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><blockquote style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><p></p><div style=\"text-align: left;\"><br></div><o:p>&nbsp;</o:p><o:p><br></o:p><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\"><span style=\"font-family: Helvetica;\">Diabliss is a renowned
brand committed to developing innovative, diabetic-friendly products without
compromising on taste. With a focus on promoting stable blood sugar levels and
overall well-being, Diabliss has gained popularity among individuals with
diabetes and health-conscious consumers alike. Now, the introduction of
Diabliss products at Bhatbhateni Super Market brings the convenience of
accessing these healthful options to a wider audience.</span></span><p></p></blockquote></blockquote><blockquote style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><blockquote style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><p></p><p><span style=\"color: black; font-family: Helvetica; font-size: 12pt; font-weight: var(--bs-body-font-weight);\">The availability of
Diabliss products at Bhatbhateni Super Market is an exciting development for
individuals with diabetes and health-conscious consumers in search of
diabetic-friendly alternatives. With their commitment to promoting stable blood
sugar levels, Diabliss offers a range of delicious and nutritious options,
including masala tea mix, herbal tea, millet cookies, diabetic-friendly sugar,
and jaggery. By incorporating these products into your lifestyle, you can enjoy
the flavors you love while making choices that support your health and
well-being. Visit Bhatbhateni Super Market today and discover the goodness of
Diabliss.</span></p><p></p></blockquote></blockquote><blockquote><br></blockquote><blockquote style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><p></p><blockquote><br></blockquote><p></p></blockquote>','Diabliss Product','55c611f5-ccbd-412f-a216-4532f8076caf.webp','','','','','0','2023-05-26 10:56:24','2023-05-26 13:50:49','15');
INSERT INTO blogs VALUES('5','are-you-thinking-what-gi-or-glycemic-index-is-heres-the-answer','1','4','Are you thinking what  GI or Glycemic Index is ?Here\'s the answer:','<h2><span style=\"font-family: Helvetica; color: black; border: 1pt none windowtext; padding: 0in;\">What is the glycemic index?</span><span style=\"font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:&quot;Times New Roman&quot;;
color:black;mso-themecolor:text1\"><o:p></o:p></span></h2><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F\"><span style=\"font-family: Helvetica;\">The glycemic index </span><i>(GI)</i><span style=\"font-family: Helvetica;\"> is a measure of how quickly a food
raises blood sugar levels. Foods with a high GI are digested and absorbed
quickly, causing a rapid rise in blood sugar levels. Foods with a low GI are
digested and absorbed more slowly, causing a gradual rise in blood sugar
levels.</span><o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F;border:none windowtext 1.0pt;
mso-border-alt:none windowtext 0in;padding:0in\"><o:p>&nbsp;</o:p></span></p><h3 style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F;border:none windowtext 1.0pt;
mso-border-alt:none windowtext 0in;padding:0in\"><b>How is the glycemic index
calculated?</b></span></h3><h3 style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F;border:none windowtext 1.0pt;
mso-border-alt:none windowtext 0in;padding:0in\"><b><br></b></span></h3><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F\"><span style=\"font-family: Helvetica;\">The glycemic index is
calculated by comparing the blood sugar response to a food with the blood sugar
response to a reference food, such as white bread or glucose. The reference
food is given a GI of 100, and other foods are given a GI based on how much
their blood sugar response differs from the reference food.</span><o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F;border:none windowtext 1.0pt;
mso-border-alt:none windowtext 0in;padding:0in\"><o:p>&nbsp;</o:p></span></p><h3><span style=\"font-family: Helvetica; color: black; border: 1pt none windowtext; padding: 0in;\">What are the benefits of a
low-GI diet?</span></h3><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F\"><span style=\"font-family: Helvetica;\">There are a number of
potential benefits to following a low-GI diet, including:</span><o:p></o:p></span></p><p class=\"MsoListParagraphCxSpFirst\" style=\"margin-top:0in;margin-right:0in;
margin-bottom:7.5pt;margin-left:39.0pt;mso-add-space:auto;text-align:justify;
text-indent:-.25in;line-height:18.0pt;mso-list:l2 level1 lfo1\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Improved blood sugar control: A low-GI diet
can help to improve blood sugar control in people with diabetes or prediabetes.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-top:0in;margin-right:0in;
margin-bottom:7.5pt;margin-left:39.0pt;mso-add-space:auto;text-align:justify;
text-indent:-.25in;line-height:18.0pt;mso-list:l2 level1 lfo1\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Reduced risk of type 2 diabetes: A low-GI diet
may help to reduce the risk of developing type 2 diabetes.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-top:0in;margin-right:0in;
margin-bottom:7.5pt;margin-left:39.0pt;mso-add-space:auto;text-align:justify;
text-indent:-.25in;line-height:18.0pt;mso-list:l2 level1 lfo1\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Weight loss: A low-GI diet may help to promote
weight loss, especially when combined with a calorie-restricted diet.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"margin-top:0in;margin-right:0in;
margin-bottom:7.5pt;margin-left:39.0pt;mso-add-space:auto;text-align:justify;
text-indent:-.25in;line-height:18.0pt;mso-list:l2 level1 lfo1\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Reduced risk of heart disease: A low-GI diet
may help to reduce the risk of heart disease by improving cholesterol levels
and reducing inflammation.<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpLast\" style=\"margin-top:0in;margin-right:0in;
margin-bottom:7.5pt;margin-left:39.0pt;mso-add-space:auto;text-align:justify;
text-indent:-.25in;line-height:18.0pt;mso-list:l2 level1 lfo1\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Reduced risk of stroke: A low-GI diet may help
to reduce the risk of stroke by improving blood pressure and reducing
inflammation.<o:p></o:p></span></p><h2><span style=\"font-family: Helvetica; color: black; border: 1pt none windowtext; padding: 0in;\">What are some low-GI foods?</span><span style=\"font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:&quot;Times New Roman&quot;;
border:none windowtext 1.0pt;mso-border-alt:none windowtext 0in;padding:0in\"><o:p></o:p></span></h2><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F\">Some examples of
low-GI foods include:<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpFirst\" style=\"margin-bottom:7.5pt;mso-add-space:
auto;text-align:justify;text-indent:-.25in;line-height:18.0pt;mso-list:l0 level1 lfo2\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Whole grains, such as brown rice, quinoa, and
whole-wheat bread<o:p></o:p></span></p><ul><li style=\"margin-bottom: 7.5pt; text-align: justify; text-indent: -0.25in; line-height: 18pt;\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Fruits, such as berries, apples, and pears<o:p></o:p></span></li><li style=\"margin-bottom: 7.5pt; text-align: justify; text-indent: -0.25in; line-height: 18pt;\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Vegetables, such as broccoli, carrots, and
spinach<o:p></o:p></span></li><li style=\"margin-bottom: 7.5pt; text-align: justify; text-indent: -0.25in; line-height: 18pt;\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Legumes, such as beans, lentils, and peas<o:p></o:p></span></li><li style=\"margin-bottom: 7.5pt; text-align: justify; text-indent: -0.25in; line-height: 18pt;\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Nuts and seeds<o:p></o:p></span></li><li style=\"margin-bottom: 7.5pt; text-align: justify; text-indent: -0.25in; line-height: 18pt;\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Lean protein, such as fish, chicken, and tofu<o:p></o:p></span></li></ul><p class=\"MsoNormal\" style=\"margin-bottom:7.5pt;text-align:justify;line-height:
18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F\"><o:p>&nbsp;</o:p></span></p><h2><span style=\"font-size: 14pt; line-height: 107%; font-family: Helvetica; color: black; border: 1pt none windowtext; padding: 0in;\"><b>How can I choose low-GI foods?</b></span><span style=\"font-size:14.0pt;mso-bidi-font-size:13.0pt;line-height:107%;font-family:
&quot;Times New Roman&quot;,serif;mso-fareast-font-family:&quot;Times New Roman&quot;;color:black;
mso-themecolor:text1\"><o:p></o:p></span></h2><p class=\"MsoNormal\" style=\"margin-top:.25in;margin-right:0in;margin-bottom:.25in;
margin-left:0in;text-align:justify;line-height:18.0pt\"><span style=\"font-size: 12pt; font-family: Helvetica; color: rgb(31, 31, 31);\">When choosing foods, it is important to look at the GI label. Foods
with a GI of 55 or less are considered low-GI foods. Foods with a GI of 70 or
more are considered high-GI foods.</span><span style=\"font-size: 12pt; color: rgb(31, 31, 31); font-family: Helvetica;\">&nbsp;</span><span style=\"color: rgb(31, 31, 31); font-family: Helvetica; font-size: 12pt; font-weight: var(--bs-body-font-weight);\">It is also important to consider the portion size when choosing
foods. Even low-GI food can have a high GI if you eat a large portion.</span></p><h2><span style=\"font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:black;mso-themecolor:text1;border:none windowtext 1.0pt;
mso-border-alt:none windowtext 0in;padding:0in\">Can I still eat high-GI foods
on a low-GI diet?</span><span style=\"font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:black;mso-themecolor:text1\"><o:p></o:p></span></h2><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F\"><span style=\"font-family: Helvetica;\">Yes, you can still eat
high-GI foods on a low-GI diet. However, it is important to limit your intake
of these foods. You can also try to balance high-GI foods with low-GI foods.
For example, you could have a slice of whole-wheat bread with a piece of fruit
for breakfast.</span><o:p></o:p></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F;border:none windowtext 1.0pt;
mso-border-alt:none windowtext 0in;padding:0in\"><o:p>&nbsp;</o:p></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F;border:none windowtext 1.0pt;
mso-border-alt:none windowtext 0in;padding:0in\"><o:p>&nbsp;</o:p></span></p><h2><span style=\"font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:black;mso-themecolor:text1;border:none windowtext 1.0pt;
mso-border-alt:none windowtext 0in;padding:0in\">What are some tips for
following a low-GI diet?<o:p></o:p></span></h2><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F\"><o:p>&nbsp;</o:p></span></p><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F\">Here are some tips for
following a low-GI diet:<o:p></o:p></span></p><p class=\"MsoListParagraphCxSpFirst\" style=\"margin-bottom:7.5pt;mso-add-space:
auto;text-align:justify;text-indent:-.25in;line-height:18.0pt;mso-list:l1 level1 lfo3\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Choose whole grains over refined grains.<o:p></o:p></span></p><ul><li style=\"margin-bottom: 7.5pt; text-align: justify; text-indent: -0.25in; line-height: 18pt;\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Eat plenty of fruits and vegetables.<o:p></o:p></span></li><li style=\"margin-bottom: 7.5pt; text-align: justify; text-indent: -0.25in; line-height: 18pt;\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Include legumes in your diet.<o:p></o:p></span></li><li style=\"margin-bottom: 7.5pt; text-align: justify; text-indent: -0.25in; line-height: 18pt;\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Choose lean protein sources.<o:p></o:p></span></li><li style=\"margin-bottom: 7.5pt; text-align: justify; text-indent: -0.25in; line-height: 18pt;\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style=\"font-family: Helvetica;\"> </span></span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\">Limit your intake of processed foods, sugary
drinks, and sweets.<o:p></o:p></span></li><li style=\"margin-bottom: 7.5pt; text-align: justify; text-indent: -0.25in; line-height: 18pt;\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;font-family:Symbol;mso-fareast-font-family:Symbol;
mso-bidi-font-family:Symbol;color:#1F1F1F\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style=\"font-family: Helvetica;\">&nbsp; </span></span></span><!--[endif]--><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:#1F1F1F\"><span style=\"font-family: Helvetica;\"><span style=\"font-family: &quot;Times New Roman&quot;;\">Cook your own meals whenever possible</span>.</span><o:p></o:p></span></li></ul><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F\"><o:p>&nbsp;</o:p></span></p><p>













































































</p><p class=\"MsoNormal\" style=\"margin-bottom:0in;margin-bottom:.0001pt;text-align:
justify;line-height:18.0pt\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:#1F1F1F\"><span style=\"font-family: Helvetica;\">The glycemic index is
a useful tool for people who want to improve their blood sugar control or lose
weight. By choosing low-GI foods, you can help to keep your blood sugar levels
stable and promote weight loss.</span><o:p></o:p></span></p>','Gi index','b07a02da-1aed-43b4-aac2-f281232a21db.webp','','','','','0','2023-05-26 12:03:24','2023-05-26 16:26:19','0');
INSERT INTO blogs VALUES('6','dialbiss-jaggery-and-diabliss-sugar-low-gi-products-for-healthy-living','1','3','Diabliss Jaggery and Diabliss Sugar: Low GI Products for Healthy Living','<p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">In the quest for a healthier lifestyle, we often seek alternatives to traditional sweeteners that can help maintain stable blood sugar levels without compromising on taste. Diabliss Jaggery and Diabliss Sugar are two exceptional products that cater to this need, offering low glycemic index (GI) alternatives that are not only delicious but also beneficial for our overall well-being. In this blog post, we will explore the features, benefits, and versatility of Diabliss Jaggery and Diabliss Sugar, highlighting why they are excellent choices for those conscious of their sugar intake.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">Diabliss Jaggery:</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">Diabliss Jaggery is an all-natural, low-GI sweetener made from sugarcane. It undergoes a unique processing method that helps retain its natural nutrients and flavors. Unlike regular jaggery, which often has high GI values, Diabliss Jaggery scores low on the GI scale, making it a healthier alternative for those concerned about their blood sugar levels. Moreover, it is free from chemicals, additives, and artificial sweeteners, ensuring a pure and wholesome product.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">&nbsp;</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">Benefits of Diabliss Jaggery:</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">·&nbsp; &nbsp; &nbsp;LowDiabliss Jaggery has a low GI value, promoting stable blood sugar levels and reducing the risk of sugar spikes and crashes.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">·&nbsp; &nbsp; &nbsp; &nbsp;Nutrient-rich: This natural sweetener contains essential minerals like iron, calcium, and magnesium, along with vitamins and antioxidants, offering additional health benefits.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">·&nbsp; &nbsp; &nbsp; &nbsp;Immunity booster: The presence of phytochemicals and antioxidants in Diabliss Jaggery helps strengthen the immune system, protecting the body from various infections and illnesses.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">·&nbsp; &nbsp; &nbsp; &nbsp;Digestive aid: Diabliss Jaggery aids digestion and helps in maintaining a healthy gut due to its natural fiber content.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">·&nbsp; &nbsp; &nbsp; &nbsp;Sustained energy release: As a low GI sweetener, it provides a slow and steady release of energy, keeping you feeling energized and satiated for longer periods.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">&nbsp;</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">Diabliss Sugar:</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">Diabliss Sugar is a premium cane sugar blend designed specifically to minimize the glycemic impact of sugar consumption. It combines the goodness of cane sugar with herbal extracts, resulting in a low GI sugar alternative that doesn\'t compromise on taste.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">&nbsp;</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">Benefits of Diabliss Sugar:</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">·&nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;Low GI: Diabliss Sugar has a significantly lower GI compared to regular cane sugar, ensuring a gradual release of glucose into the bloodstream.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">·&nbsp; &nbsp; &nbsp; &nbsp;Taste and texture: It retains the familiar taste and texture of regular sugar, making it an easy substitution in recipes and beverages without sacrificing flavor.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">·&nbsp; &nbsp; &nbsp; &nbsp;Diabetic-friendly: Its low GI nature makes it suitable for individuals with diabetes or those aiming to regulate their blood sugar levels.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">·&nbsp; &nbsp; &nbsp; &nbsp;Weight management: Diabliss Sugar\'s low GI helps control cravings and may assist in managing weight by preventing sudden spikes in blood sugar that lead to hunger and overeating.</font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\"><br></font></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><font color=\"#000000\" face=\"Arial\">Diabliss Jaggery and Diabliss Sugar are excellent alternatives to traditional sweeteners, providing the perfect balance between taste and health benefits. Both products have low glycemic index values, ensuring stable blood sugar levels, while offering essential nutrients and delightful flavors. By incorporating Diabliss Jaggery and Diabliss Sugar into your daily routine, you can make a positive impact on your overall well-being and take significant steps towards a healthier lifestyle.</font></p>','Diabliss Products','3bfa219d-6bdc-4bf5-bfc2-c090783643c2.webp','','','','','0','2023-05-26 12:12:37','2023-05-28 04:31:00','12');
INSERT INTO blogs VALUES('7','diabliss-combo-offer-a-sweet-deal-for-diabetic-friendly-delights','1','3','Diabliss Combo Offer: A Sweet Deal for Diabetic-Friendly Delights','<p class=\"MsoNormal\"><span style=\"font-size:12.0pt;line-height:107%;font-family:
&quot;Times New Roman&quot;,serif;mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\"><span style=\"font-family: Helvetica;\">Finding
the perfect combination of diabetic-friendly products that are both delicious
and beneficial can be a challenge. However, Diabliss has come up with an
exciting solution: the Diabliss Combo Offer. This irresistible deal brings
together a selection of their finest diabetic-friendly products, allowing
individuals with diabetes and health-conscious consumers to enjoy a variety of
treats while maintaining stable blood sugar levels. In this blog post, we will
explore the Diabliss Combo Offer and the advantages it brings to those seeking
healthier alternatives.</span><o:p></o:p></span></p><p class=\"MsoNormal\"><span style=\"font-size:12.0pt;line-height:107%;font-family:
&quot;Times New Roman&quot;,serif;mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\"><o:p>&nbsp;</o:p></span></p><h4><span style=\"font-size:12.0pt;mso-bidi-font-size:13.0pt;line-height:107%;
font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:&quot;Times New Roman&quot;;
color:black;mso-themecolor:text1\"><span style=\"font-family: Helvetica;\">The Diabliss Combo Offer:</span></span></h4><p class=\"MsoNormal\"><o:p>&nbsp;</o:p><span style=\"font-family: Helvetica; color: black; font-size: 12pt; font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">The
Diabliss Combo Offer is a carefully curated package that combines a range of
diabetic-friendly products from the Diabliss collection. With this special
offer, you can enjoy a diverse selection of flavors and textures while ensuring
that your sugar intake remains under control.</span></p><p class=\"MsoNormal\"><span style=\"font-size:12.0pt;line-height:107%;font-family:
&quot;Times New Roman&quot;,serif;mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\"><o:p>&nbsp;</o:p></span><span style=\"font-family: Helvetica; color: black; font-size: 12pt; text-align: var(--bs-body-text-align);\">What\'s Included in the Combo Offer:</span><span style=\"color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">&nbsp;</span></p><h5 style=\"text-indent:-.25in;mso-list:l1 level1 lfo2\"><span style=\"font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\">1.<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;<span style=\"font-family: Helvetica;\"> </span></span></span><!--[endif]--><span style=\"font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\"><span style=\"font-family: Helvetica; background-color: rgb(239, 239, 239);\">Diabliss Masala Tea Mix</span>:
<span style=\"font-family: Helvetica;\">Start your day with a warm cup of Diabliss Masala Tea Mix. This unique blend of
premium tea and aromatic spices is designed to provide a burst of flavor
without the added sugar. With the combo offer, you can savor the invigorating
goodness of this diabetic-friendly tea mix, perfectly balancing taste and
health benefits.</span><o:p></o:p></span></h5><p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;mso-list:l1 level1 lfo2\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\">2.<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size: 12pt; line-height: 107%; font-family: &quot;Times New Roman&quot;, serif; background-color: rgb(239, 239, 239);\"><font color=\"#000000\">Diabliss Herbal Tea</font></span><span style=\"font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\">: <span style=\"font-family: Helvetica;\">Indulge
in the soothing and refreshing experience of Diabliss Herbal Tea. Crafted from
a blend of hand-picked herbs and spices, this zero-calorie, zero-sugar infusion
promotes relaxation and overall wellness. With the combo offer, you can enjoy a
variety of herbal tea flavors, expanding your options for guilt-free enjoyment.</span><o:p></o:p></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;mso-list:l1 level1 lfo2\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\">3.<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size: 12pt; line-height: 107%; font-family: &quot;Times New Roman&quot;, serif;\"><span style=\"font-family: Helvetica; background-color: rgb(239, 239, 239);\"><font color=\"#000000\">Diabliss Millet Cookies</font></span><font color=\"#000000\">:
</font><span style=\"color: black; font-family: Helvetica;\">Craving a crunchy and wholesome snack? The Diabliss Combo Offer includes a
selection of Diabliss Millet Cookies. Made from nutrient-rich millets and
natural ingredients, these cookies offer a low glycemic index alternative to
traditional cookies. With flavors like chocolate chip and cranberry, each bite
is a delightful treat that supports your health goals.</span><font color=\"#000000\"><o:p></o:p></font></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;mso-list:l1 level1 lfo2\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\"><span style=\"font-family: Helvetica;\">4.</span><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: Helvetica;\">&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size: 12pt; line-height: 107%; font-family: &quot;Times New Roman&quot;, serif;\"><span style=\"font-family: Helvetica; background-color: rgb(239, 239, 239);\"><font color=\"#000000\">Diabliss
Diabetic-Friendly Sugar</font></span><font color=\"#000000\">:</font><span style=\"color: black; font-family: Helvetica;\"> Managing your sugar intake becomes easier with the
Diabliss Combo Offer, as it includes Diabliss Diabetic-Friendly Sugar. This
special sugar blend, derived from natural cane sugar and herbal extracts,
offers a low glycemic index alternative to regular sugar. Use it in your
favorite recipes and beverages without compromising on taste, while keeping
your blood sugar levels in check.</span><font color=\"#000000\"><o:p></o:p></font></span></p><p class=\"MsoListParagraphCxSpLast\" style=\"text-indent:-.25in;mso-list:l1 level1 lfo2\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;line-height:107%;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\">5.<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size: 12pt; line-height: 107%; font-family: &quot;Times New Roman&quot;, serif;\"><span style=\"font-family: Helvetica; background-color: rgb(239, 239, 239);\"><font color=\"#000000\">Diabliss Jaggery</font></span><font color=\"#000000\">: </font><span style=\"color: black; font-family: Helvetica;\">Complete
the combo offer with Diabliss Jaggery, a healthy and low glycemic index
sweetener derived from sugarcane. With its natural nutrients, vitamins, and
minerals, Diabliss Jaggery provides a flavorful and diabetic-friendly
substitute for traditional jaggery. Enhance the taste of your favorite dishes
or beverages while maintaining stable blood sugar levels.</span><font color=\"#000000\"><o:p></o:p></font></span></p><p class=\"MsoNormal\"><span style=\"font-size:12.0pt;line-height:107%;font-family:
&quot;Times New Roman&quot;,serif;mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\"><o:p>&nbsp;</o:p></span></p><h5><span style=\"font-family:&quot;Times New Roman&quot;,serif;mso-fareast-font-family:
&quot;Times New Roman&quot;;color:black;mso-themecolor:text1\">Advantages of the Diabliss
Combo Offer:</span></h5><p class=\"MsoListParagraphCxSpFirst\" style=\"text-indent:-.25in;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;line-height:107%;font-family:Symbol;mso-fareast-font-family:
Symbol;mso-bidi-font-family:Symbol;color:black\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size: 12pt; line-height: 107%; font-family: &quot;Times New Roman&quot;, serif;\"><span style=\"font-family: Helvetica; background-color: rgb(239, 239, 239);\"><font color=\"#000000\">Convenience</font></span><font color=\"#000000\">: </font><span style=\"color: black; font-family: Helvetica;\">The
Diabliss Combo Offer brings together a variety of diabetic-friendly products in
one package, saving you time and effort in sourcing them individually.</span><font color=\"#000000\"><o:p></o:p></font></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span style=\"font-size: 12pt; line-height: 107%; font-family: Symbol;\"><font color=\"#000000\">·</font><span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\"><font color=\"#000000\">&nbsp;&nbsp;<span style=\"background-color: rgb(239, 239, 239);\">&nbsp;&nbsp;&nbsp;&nbsp; </span></font></span></span><!--[endif]--><span style=\"font-size: 12pt; line-height: 107%; font-family: &quot;Times New Roman&quot;, serif;\"><span style=\"font-family: Helvetica; background-color: rgb(239, 239, 239);\"><font color=\"#000000\">Versatility</font></span><font color=\"#000000\">:</font><span style=\"color: black; font-family: Helvetica;\"> With a
range of products included, the combo offer allows you to explore different
flavors and textures, adding variety to your diabetic-friendly diet.</span><font color=\"#000000\"><o:p></o:p></font></span></p><p class=\"MsoListParagraphCxSpMiddle\" style=\"text-indent:-.25in;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;line-height:107%;font-family:Symbol;mso-fareast-font-family:
Symbol;mso-bidi-font-family:Symbol;color:black\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; </span></span><!--[endif]--><span style=\"font-size: 12pt; line-height: 107%; font-family: &quot;Times New Roman&quot;, serif;\"><span style=\"font-family: Helvetica; background-color: rgb(239, 239, 239);\"><font color=\"#000000\">Balanced Blood Sugar
Levels</font></span><font color=\"#000000\">: </font><span style=\"color: black; font-family: Helvetica;\">Each product in the combo offer has a low glycemic index, helping you
maintain stable blood sugar levels and reducing the risk of sugar spikes and
crashes.</span><font color=\"#000000\"><o:p></o:p></font></span></p><p class=\"MsoListParagraphCxSpLast\" style=\"text-indent:-.25in;mso-list:l0 level1 lfo1\"><!--[if !supportLists]--><span style=\"font-size:12.0pt;line-height:107%;font-family:Symbol;mso-fareast-font-family:
Symbol;mso-bidi-font-family:Symbol;color:black\">·<span style=\"font-variant-numeric: normal; font-variant-east-asian: normal; font-variant-alternates: normal; font-kerning: auto; font-optical-sizing: auto; font-feature-settings: normal; font-variation-settings: normal; font-stretch: normal; font-size: 7pt; line-height: normal; font-family: &quot;Times New Roman&quot;;\">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span style=\"font-family: Helvetica;\"> </span></span></span><!--[endif]--><span style=\"font-size: 12pt; line-height: 107%; font-family: &quot;Times New Roman&quot;, serif;\"><span style=\"font-family: Helvetica; background-color: rgb(239, 239, 239);\"><font color=\"#000000\">Guilt-Free Indulgence</font></span><font color=\"#000000\">:
</font><span style=\"color: black; font-family: Helvetica;\">Enjoy the flavors you love without compromising on your health goals. The
Diabliss Combo Offer ensures you can savor delicious treats while making
mindful choices.</span><font color=\"#000000\"><o:p></o:p></font></span></p><p class=\"MsoNormal\"><span style=\"font-size:12.0pt;line-height:107%;font-family:
&quot;Times New Roman&quot;,serif;mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\"><o:p>&nbsp;</o:p></span></p><p>







































</p><p class=\"MsoNormal\"><span style=\"font-size:12.0pt;line-height:107%;font-family:
&quot;Times New Roman&quot;,serif;mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\"><span style=\"font-family: Helvetica;\">The
Diabliss Combo Offer is a sweet deal that brings together an array of
diabetic-friendly products, offering a well-rounded selection of flavors and
textures. With this exclusive package,<span style=\"font-family: Helvetica;\">&nbsp;</span></span><o:p></o:p></span><span style=\"color: black; font-family: &quot;Times New Roman&quot;, serif; font-size: 12pt; text-align: justify; font-weight: var(--bs-body-font-weight);\"><span style=\"font-family: Helvetica;\">you can enjoy the
benefits of Diabliss Masala Tea Mix, Herbal Tea, Millet </span><span style=\"font-family: Helvetica;\">Cookies,
Diabetic-Friendly Sugar, and Jaggery. Embrace this opportunity to experience
the deliciousness of Diabliss while prioritizing your health and</span> <span style=\"font-family: Helvetica;\">well-being.
Don\'t miss out on this irresistible offer that caters to your diabetic-friendly
needs.</span></span></p><p class=\"MsoNormal\" style=\"margin-bottom: 7.5pt; text-align: justify; line-height: normal; background-image: initial; background-position: initial; background-size: initial; background-repeat: initial; background-attachment: initial; background-origin: initial; background-clip: initial;\"><span style=\"font-size:12.0pt;font-family:&quot;Times New Roman&quot;,serif;
mso-fareast-font-family:&quot;Times New Roman&quot;;color:black\"><o:p></o:p></span></p>','Combo Offer','1e23c749-486c-4bc2-aed1-c5d7b0796064.webp','','','','','0','2023-05-26 13:43:29','2023-05-26 13:55:20','6');



DROP TABLE IF EXISTS buy_methods;

CREATE TABLE `buy_methods` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `summary` longtext NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `buy_methods_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO buy_methods VALUES('1','282513c6-f479-48b6-becb-d7e8f6090469','1','Buy Now For Diabetic Product','Shop now for a variety of diabetic products that are specially designed to support your health and well-being.','c0297dc6-3ed8-460c-80d4-881a8fe64e75.webp','1','2023-05-17 08:32:10','2023-05-21 14:07:10');
INSERT INTO buy_methods VALUES('2','38b8400f-f425-4f84-962c-b7dbda03af4d','1','Sign up & Get Verified','Sign up and get verified to access our platform\'s features and services.','','1','2023-05-17 08:33:53','2023-05-21 13:38:13');
INSERT INTO buy_methods VALUES('3','5a787e00-2118-4094-b821-e0469c70b5e9','1','Order Online','Order online now to conveniently purchase our products from the comfort of your own home.','','1','2023-05-17 08:34:07','2023-05-21 13:38:49');
INSERT INTO buy_methods VALUES('4','03f8241e-7287-47cd-90cb-3ab6cef30b62','1','Receive your order','Receive your order conveniently at your doorstep.','','1','2023-05-17 08:34:21','2023-05-21 13:39:30');



DROP TABLE IF EXISTS candidates;

CREATE TABLE `candidates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone_number` varchar(255) NOT NULL,
  `current_address` varchar(255) NOT NULL,
  `permanent_address` varchar(255) NOT NULL,
  `date_of_birth` varchar(255) NOT NULL,
  `gender` varchar(255) NOT NULL,
  `post_name` varchar(255) NOT NULL,
  `education` varchar(255) NOT NULL,
  `experince` varchar(255) NOT NULL,
  `resume` varchar(255) NOT NULL,
  `remarks` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `candidates_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO candidates VALUES('1','4bf734e2-ff2d-4787-9d6d-b08295ba57a7','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Ramkot, Kathmandu','Bara, Nepal','2023-05-12','Male','Frontend Developer','BCA Running','3+ year','caa302da-b71a-4910-8784-9cbd89edb27a.docx','Something','2023-05-12 08:05:26','2023-05-12 08:05:26');



DROP TABLE IF EXISTS careers;

CREATE TABLE `careers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `description` longtext NOT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_image` varchar(255) DEFAULT NULL,
  `seo_keyword` longtext DEFAULT NULL,
  `seo_description` longtext DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `careers_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS catalogues;

CREATE TABLE `catalogues` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `file` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `catalogues_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO catalogues VALUES('1','something','1','Something','e155a741-f938-435e-8084-aa23190b7a1f.jpg','a9a8ec22-9749-416f-a488-d8679538420d.pdf','1','2023-05-10 18:36:16','2023-05-12 07:02:38');



DROP TABLE IF EXISTS categories;

CREATE TABLE `categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `parent_category` int(11) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `display_home` int(255) NOT NULL DEFAULT 0,
  `order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `categories_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO categories VALUES('1','low-gi-products','1','LOW GI Prouduct','','','1','2023-04-24 04:14:02','2023-05-12 06:06:58','0','0');
INSERT INTO categories VALUES('2','herbal-water','1','Herbal Water','','','1','2023-04-28 16:01:17','2023-05-12 06:06:59','0','0');
INSERT INTO categories VALUES('3','blood-glucose-management','1','Blood Glucose Management','2','','1','2023-04-28 16:18:42','2023-05-12 06:07:00','0','0');
INSERT INTO categories VALUES('4','hypertension-management','1','Hypertension Management','2','','1','2023-04-28 16:19:56','2023-05-12 06:07:00','0','0');
INSERT INTO categories VALUES('5','immunity-boost','1','Immunity Boost','2','','1','2023-04-28 16:20:48','2023-05-12 06:07:01','0','0');
INSERT INTO categories VALUES('6','skin-care','1','Skin Care','2','','1','2023-04-28 16:21:35','2023-05-12 06:07:03','0','0');
INSERT INTO categories VALUES('9','hair-care','1','Hair Care','2','23e91524-cb5b-44e6-8b8e-809cbff19bea.webp','1','2023-04-28 16:25:50','2023-05-17 14:41:51','1','0');
INSERT INTO categories VALUES('10','herbal-water-combo','1','Herbal Water','2','88071a4e-11f8-459c-a452-55783ef1b143.webp','1','2023-04-28 16:26:25','2023-05-17 15:24:40','0','0');
INSERT INTO categories VALUES('11','diabliss-sugar','1','Diabliss Sugar','1','7df8a42e-4247-421b-be27-4c0440e46791.webp','1','2023-04-28 16:28:17','2023-05-24 13:00:58','1','0');
INSERT INTO categories VALUES('12','diabliss-jagger','1','Diabliss Jaggery','1','','1','2023-04-28 16:28:31','2023-05-12 06:07:07','0','0');
INSERT INTO categories VALUES('13','diabliss-tea','1','Diabliss Tea','1','883ae324-ffaa-4a73-acd9-9f339146bee9.webp','1','2023-04-28 16:29:36','2023-05-23 14:25:58','1','0');
INSERT INTO categories VALUES('14','diabliss-jam','1','Diabliss Jam','1','','1','2023-04-28 16:31:19','2023-05-12 06:07:10','0','0');
INSERT INTO categories VALUES('18','combo-package','1','Combo Package','','','0','2023-06-12 15:13:48','2023-06-12 15:13:48','0','0');



DROP TABLE IF EXISTS clients;

CREATE TABLE `clients` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `clients_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS complain_types;

CREATE TABLE `complain_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `complain_types_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO complain_types VALUES('1','6ebf75a6-4bf3-46ef-ac43-4f6b296c80c9','1','Product','1','2023-05-11 04:28:18','2023-05-12 06:30:37');



DROP TABLE IF EXISTS complains;

CREATE TABLE `complains` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone_number` varchar(255) NOT NULL,
  `state` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `street` varchar(255) NOT NULL,
  `landmark` varchar(255) DEFAULT NULL,
  `category` varchar(255) DEFAULT NULL,
  `product_name` varchar(255) NOT NULL,
  `complain_type` varchar(255) NOT NULL,
  `warrenty` varchar(255) DEFAULT NULL,
  `bill_card` varchar(255) DEFAULT NULL,
  `date_of_purchase` varchar(255) NOT NULL,
  `remarks` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `complains_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO complains VALUES('1','257d8f7b-aa7e-47b3-9cdb-9b664dd7925d','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Madhesh Province','Kathmandu','Ramkot','Ramkot - 13','Sitapaila','Diabliss Atta','Something','Product','38452ec9-a777-4a31-80dd-bad53b15f94b.jpg','bb0147c6-fad1-4208-9c30-40f20bea08e5.jpg','2023-05-12','Nothing','2023-05-12 06:39:54','2023-05-12 06:39:54');
INSERT INTO complains VALUES('2','7327b489-62ba-43da-b3a9-d52b6f6434ee','sandy dude','bvc@gng.ccmc','7894561230','Koshi Province','asddcdfervchtrh','kathmandu','bbbttyy','mannnnn','Diabliss Atta','BRAVO Home UPS 120 VA + Tabular Battery 150 AH/12','Product','','','7777-01-22','','2023-05-23 11:29:45','2023-05-23 11:29:45');



DROP TABLE IF EXISTS contact_forms;

CREATE TABLE `contact_forms` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone_number` varchar(255) NOT NULL,
  `message` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO contact_forms VALUES('1','fab6036b-45f7-462e-b359-1cd8ebe0657c','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-05-12 05:41:14','2023-05-12 05:41:14');
INSERT INTO contact_forms VALUES('2','93b628e3-c845-4287-9ba1-81872b6b0a66','sanskar','sanskarpokharel@gmail.com','9876543210','hello how are you','2023-05-17 13:07:58','2023-05-17 13:07:58');
INSERT INTO contact_forms VALUES('3','d1457c53-95c8-4248-929c-390cd35cc812','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-12 18:21:34','2023-08-12 18:21:34');
INSERT INTO contact_forms VALUES('4','880188e1-53e6-4962-a2d0-8bf06d7ef07d','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-12 18:22:00','2023-08-12 18:22:00');
INSERT INTO contact_forms VALUES('5','3fd3fba2-bd8c-4494-b24f-38defc0b9685','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-12 18:22:15','2023-08-12 18:22:15');
INSERT INTO contact_forms VALUES('6','2726e4ab-edcd-4bc3-a531-4c344db64d8b','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-12 18:24:34','2023-08-12 18:24:34');
INSERT INTO contact_forms VALUES('7','369635d0-01e6-4917-acb5-7ddb9e6a7631','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-12 18:25:15','2023-08-12 18:25:15');
INSERT INTO contact_forms VALUES('8','db50215a-46cf-4ff0-bcdb-c9f9b2a71b12','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-12 18:27:24','2023-08-12 18:27:24');
INSERT INTO contact_forms VALUES('9','82341c5c-c010-4619-a01e-1b5910b2ce62','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-12 18:30:08','2023-08-12 18:30:08');
INSERT INTO contact_forms VALUES('10','e28df245-3dd8-4246-b413-eb67733e1cdf','Rupesh','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-13 00:20:13','2023-08-13 00:20:13');
INSERT INTO contact_forms VALUES('11','bdba95bf-3dda-4ffc-96d3-8acddae9a8bd','Rupesh','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-13 00:25:56','2023-08-13 00:25:56');
INSERT INTO contact_forms VALUES('12','3cf93662-6855-4b9d-9259-3acfdb6c6aaf','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-13 00:28:42','2023-08-13 00:28:42');
INSERT INTO contact_forms VALUES('13','83461549-db69-4d62-a868-c004938df983','Rupesh','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-13 00:42:55','2023-08-13 00:42:55');
INSERT INTO contact_forms VALUES('14','96322af2-8bf6-448e-bf65-cc5dcee375ed','Rupesh','rupeshchaudhary7338@gmail.com','9880227545','Hi','2023-08-13 00:43:15','2023-08-13 00:43:15');



DROP TABLE IF EXISTS contacts;

CREATE TABLE `contacts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `date_of_birth` varchar(255) NOT NULL,
  `problem` varchar(255) NOT NULL,
  `message` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `contacts_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS customer_enquiries;

CREATE TABLE `customer_enquiries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `message` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO customer_enquiries VALUES('1','9a2f743c-afca-450f-95f3-d6e35e8f9eae','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Ramkot, Kathmandu','Nothing','2023-05-12 08:59:25','2023-05-12 08:59:25');



DROP TABLE IF EXISTS dealer_enquiries;

CREATE TABLE `dealer_enquiries` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `company_name` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `message` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO dealer_enquiries VALUES('1','eaffac2c-b39b-4cf2-a98e-3b798045c190','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Relive Nepal','Ramkot, Kathmandu','Something','2023-05-12 09:01:27','2023-05-12 09:01:27');



DROP TABLE IF EXISTS dealer_requests;

CREATE TABLE `dealer_requests` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `company_name` varchar(255) NOT NULL,
  `pan_no` varchar(255) NOT NULL,
  `pan_file` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `note` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO dealer_requests VALUES('2','b5c5fd0f-93b0-41df-89ee-96c0f58c572f','Mamata Gurung','mamatagurung@gmail.com','9880227545','Purano Kitab','985622','9db370e8-d7a4-4512-aad3-f67aca4d3749.jpg','Gongabu','Nothing','2023-05-10 08:44:28','2023-05-10 08:44:28');
INSERT INTO dealer_requests VALUES('3','923faa59-df24-4ffb-9b82-4ea2debfed88','Nisha Karki','nisha@gmail.com','9810380699','Info Security Nepal','12386','0e57b4f5-b7e6-4280-98b9-277d85ab96b0.jpg','Sitaban','Musi','2023-05-10 08:46:20','2023-05-10 08:46:20');
INSERT INTO dealer_requests VALUES('4','d4798efe-66cf-4c18-ae34-0c41c373e602','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','9880227545','Relive Nepal','558899','24b2c960-ef9a-418b-b753-1c90ee19db9b.jpg','Ramkot, Kathmandu','Something','2023-05-12 04:30:45','2023-05-12 04:30:45');
INSERT INTO dealer_requests VALUES('5','6a83c608-b3e7-41ff-a51f-5e3ec38dfbda','regt df','dfd@email.com','9880227545','df','9880558','ac35165e-64a0-41a8-9fd0-291d5581c2b3.jpg','dfd','dfdf','2023-05-16 17:21:35','2023-05-16 17:21:35');
INSERT INTO dealer_requests VALUES('6','3a924d4a-1c1f-4ad5-8e0f-ab8daddc60c7','Sanskar Pokharel','sanskarpokharel@gmail.com','9862170988','Herbal Corp','987654321','de10a217-1691-46eb-822c-7b800b70144f.jpg','BUdanilkantha-10, Kathmandu','Herbal Products','2023-05-17 13:00:39','2023-05-17 13:00:39');
INSERT INTO dealer_requests VALUES('8','1f655324-7c62-4bb5-9748-2029ca64e5d2','Nisha Karki','karkinisha536@gmail.com','9813443883','infinity','123456','c311fea7-ede3-466b-9ae3-0ba957828a8e.jpg','123','asdfgbn','2023-05-17 13:54:19','2023-05-17 13:54:19');



DROP TABLE IF EXISTS failed_jobs;

CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS faq_types;

CREATE TABLE `faq_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `faq_types_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO faq_types VALUES('1','f5e2b94e-4768-4f6c-ac50-a2695dea3913','1','Products','1','2023-04-27 14:28:24','2023-05-11 10:47:04');
INSERT INTO faq_types VALUES('2','1fbbd22f-29f0-4cb5-89ba-7d7a1acb1184','1','Customer Management','1','2023-04-27 14:28:40','2023-05-11 10:47:00');
INSERT INTO faq_types VALUES('3','08d30dc2-df9e-4b23-8109-a932dbd4c2dd','1','Dealer Management','1','2023-04-27 14:28:52','2023-05-11 10:33:12');



DROP TABLE IF EXISTS faqs;

CREATE TABLE `faqs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `faq_type_id` int(11) NOT NULL,
  `slug` varchar(255) DEFAULT NULL,
  `question` varchar(255) NOT NULL,
  `answer` longtext DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO faqs VALUES('1','1','1','584a3449-b606-4c1b-bcd8-92f20d962314','What is bio-availability?','The proportion of an ingredient which enters the blood circulation when introduced into the body is termed as bio-availability.','','','','1','2023-04-27 14:55:03','2023-05-12 03:22:12');
INSERT INTO faqs VALUES('2','1','1','7809e817-b651-4263-8a65-3c1fb106efbe','Why is bio-availability important?','As blood transports to every part of the body, foods and nutrients we consume are digested or converted into a water-soluble form which is the most effective pathway for the nutrients to be transported to various organs through the blood stream to deliver beneficial properties.

The human body contains over 60% water.  In human body, brain and heart are composed of 73% water, and the lungs are about 83% water. The skin contains 64% water, muscles and kidneys are 79%, and the bones are 31%.

As Diabliss Herbal Waters are uniquely created from a multi-component patent pending water-soluble technology, we are delivering outstanding efficacy and effectiveness due to high bio-availability and tackling multiple mechanisms of action.','','','','1','2023-05-02 18:08:23','2023-05-12 03:22:11');
INSERT INTO faqs VALUES('3','1','1','3acf45be-779c-41f8-ba8d-f34577c9e306','Is Diabliss Herbal Water for managing hypertension a medication?','Diabliss Herbal Water for Managing Hypertension is not a medication. It is an adjuvant which provides support in managing hypertension along with current medications. Consumers should continue to follow their medical regimen prescribed by their physicians under continued monitored conditions.','','','','1','2023-05-02 18:09:00','2023-05-12 03:22:10');
INSERT INTO faqs VALUES('4','1','1','c3436f68-401e-4369-a3a0-a31039366741','Is Diabliss Herbal Water to Manage Hypertension safe?','Diabliss Herbal Water for Managing Hypertension is made with 100% herbs and spices. These traditional food herbs and spices have been used in Indian cuisine for 1000s of years and have also been studied by leading global medical research organizations for their safety and efficacy.','','','','1','2023-05-02 18:09:36','2023-05-12 03:22:09');
INSERT INTO faqs VALUES('5','1','2','837c1a87-6d1d-4e78-aaec-ed8e5e014b38','I am a non-hypertensive; can I consume Diabliss Herbal Water for Managing Hypertension?','The herbs and spices used in Diabliss Herbal Water for Managing Hypertension have many beneficial attributes for overall health and wellness when used in moderation. However, we recommend you to consult your physician prior to use of Diabliss Herbal Water for Managing Hypertension.','','','','1','2023-05-02 18:10:31','2023-05-12 03:22:09');
INSERT INTO faqs VALUES('6','1','2','3abb881e-d65f-41f7-bf47-8998d1710a35','I am a hypertensive and I also have type 2 diabetes. Can I consume both waters together?','Diabliss Herbal Waters for hypertension management and blood glucose management are made with food grade herbs and spices which have been used in human cuisines for 1000s of years, thereby assuring safety.  The quantity of each of the herbs & spices used in the suggested daily quantity for both the herbal waters put together is well within FSSAI recommended limits.  As always, consumers should consult their physicians prior to starting consumption of Diabliss Herbal Waters.','','','','1','2023-05-02 18:10:58','2023-05-12 03:22:06');
INSERT INTO faqs VALUES('7','1','3','ce53c1eb-c6da-47ef-b006-cdceb8353216','Can you substantiate with scientific data to back up your claims?','Unlike many herbal supplements who do not have actual clinical data on the efficacy of their herbal supplements, Diabliss has conducted human clinical trials with Diabliss Herbal Water for Managing Hypertension among 50 hypertensive patients for 180 days. While the clinical data have demonstrated substantial benefits, note that individual results may vary and consumers should continue to follow the regimen prescribed by their physicians under usual monitored conditions.','','','','1','2023-05-02 18:11:31','2023-05-12 03:21:46');
INSERT INTO faqs VALUES('8','','1','d1e2408b-37db-4502-969d-bba35c3d822b','How are you?','I am Fine.','Rupesh Chaudhary','rupeshchaudhary7338@gmail.com','','1','2023-05-12 03:16:55','2023-05-12 03:54:54');



DROP TABLE IF EXISTS images;

CREATE TABLE `images` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `images_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS joblists;

CREATE TABLE `joblists` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `salary` varchar(255) NOT NULL DEFAULT 'Negotiable',
  `time` varchar(255) DEFAULT NULL,
  `education` varchar(255) NOT NULL,
  `experince` varchar(255) NOT NULL,
  `no_of_vacancy` varchar(255) DEFAULT NULL,
  `deadline` varchar(255) DEFAULT NULL,
  `description` longtext NOT NULL,
  `status` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO joblists VALUES('1','frontend-developer','1','Frontend Developer','Negotiable','Part Time','Bachelor Degree','2 years','1 Male / 2 Female','','<ul><li>Create visual concepts and designs for various mediums, such as websites, social media, print materials and more</li><li>Use graphic design software, such as Adobe Creative Suite ( Photoshop, Illustrator, InDesign), to create digital and print designs.</li><li>Adjust designs to fit the needs and incorporate feedback and revisions as necessary.<br></li></ul>','1','2023-05-11 02:48:12','2023-05-12 07:17:14');



DROP TABLE IF EXISTS migrations;

CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO migrations VALUES('1','2014_10_12_000000_create_users_table','1');
INSERT INTO migrations VALUES('2','2014_10_12_100000_create_password_resets_table','1');
INSERT INTO migrations VALUES('3','2019_08_19_000000_create_failed_jobs_table','1');
INSERT INTO migrations VALUES('4','2019_12_14_000001_create_personal_access_tokens_table','1');
INSERT INTO migrations VALUES('5','2023_04_08_082019_create_contacts_table','1');
INSERT INTO migrations VALUES('6','2023_04_13_084402_create_permission_tables','1');
INSERT INTO migrations VALUES('7','2023_04_23_110618_create_blogs_table','1');
INSERT INTO migrations VALUES('8','2023_04_23_110632_create_catalogues_table','1');
INSERT INTO migrations VALUES('9','2023_04_23_110645_create_pages_table','1');
INSERT INTO migrations VALUES('10','2023_04_23_110719_create_settings_table','1');
INSERT INTO migrations VALUES('11','2023_04_23_110735_create_products_table','1');
INSERT INTO migrations VALUES('12','2023_04_23_110744_create_faqs_table','1');
INSERT INTO migrations VALUES('13','2023_04_23_110817_create_careers_table','1');
INSERT INTO migrations VALUES('14','2023_04_23_110851_create_applications_table','1');
INSERT INTO migrations VALUES('15','2023_04_23_110935_create_testimonials_table','1');
INSERT INTO migrations VALUES('16','2023_04_23_110948_create_sliders_table','1');
INSERT INTO migrations VALUES('17','2023_04_23_111004_create_clients_table','1');
INSERT INTO migrations VALUES('18','2023_04_23_111020_create_offers_table','1');
INSERT INTO migrations VALUES('19','2023_04_24_030708_create_categories_table','2');
INSERT INTO migrations VALUES('20','2023_04_24_045003_create_faq_types_table','3');
INSERT INTO migrations VALUES('22','2023_05_08_045133_create_shops_table','4');
INSERT INTO migrations VALUES('23','2023_05_08_115323_create_dealer_requests_table','4');
INSERT INTO migrations VALUES('24','2023_05_08_121633_create_offer_products_table','4');
INSERT INTO migrations VALUES('25','2023_05_08_121825_alter_added_details_to_products','4');
INSERT INTO migrations VALUES('26','2023_05_10_101214_create_units_table','5');
INSERT INTO migrations VALUES('27','2023_05_10_165611_create_product_requests_table','6');
INSERT INTO migrations VALUES('28','2023_05_10_173959_create_plugins_table','7');
INSERT INTO migrations VALUES('29','2023_05_10_195942_create_contact_forms_table','8');
INSERT INTO migrations VALUES('30','2023_05_10_200151_create_subscribers_table','9');
INSERT INTO migrations VALUES('31','2023_05_11_022157_create_joblists_table','10');
INSERT INTO migrations VALUES('32','2023_05_11_030803_create_candidates_table','11');
INSERT INTO migrations VALUES('33','2023_05_11_033117_create_complains_table','12');
INSERT INTO migrations VALUES('34','2023_05_11_033129_create_complain_types_table','12');
INSERT INTO migrations VALUES('35','2023_05_11_050316_create_blog_categories_table','13');
INSERT INTO migrations VALUES('36','2023_05_11_094704_alter_added_details_to_categories','14');
INSERT INTO migrations VALUES('37','2023_05_12_052242_alter_added_details_to_blogs','15');
INSERT INTO migrations VALUES('38','2023_05_12_082538_create_dealer_enquiries_table','16');
INSERT INTO migrations VALUES('39','2023_05_12_082559_create_customer_enquiries_table','16');
INSERT INTO migrations VALUES('40','2023_05_13_084933_create_buy_methods_table','17');
INSERT INTO migrations VALUES('41','2023_05_14_014245_create_qualities_table','18');
INSERT INTO migrations VALUES('42','2023_05_14_014350_create_offer_requests_table','18');
INSERT INTO migrations VALUES('43','2023_05_14_014500_create_about_pages_table','19');
INSERT INTO migrations VALUES('44','2023_05_14_180635_create_images_table','20');
INSERT INTO migrations VALUES('45','2023_08_12_103810_alter_added_details_to_pages','21');
INSERT INTO migrations VALUES('46','2023_08_12_112807_create_page_seos_table','22');



DROP TABLE IF EXISTS model_has_permissions;

CREATE TABLE `model_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`model_id`,`model_type`),
  KEY `model_has_permissions_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS model_has_roles;

CREATE TABLE `model_has_roles` (
  `role_id` bigint(20) unsigned NOT NULL,
  `model_type` varchar(255) NOT NULL,
  `model_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`role_id`,`model_id`,`model_type`),
  KEY `model_has_roles_model_id_model_type_index` (`model_id`,`model_type`),
  CONSTRAINT `model_has_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO model_has_roles VALUES('1','App\\Models\\User','1');



DROP TABLE IF EXISTS offer_products;

CREATE TABLE `offer_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `offer_id` int(11) NOT NULL,
  `product_id` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `offer_products_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO offer_products VALUES('4','2b61370f-67dc-4b5b-bbd9-1c4aefc43e94','2','14','0','2023-05-10 16:04:56','2023-05-10 16:04:56');
INSERT INTO offer_products VALUES('5','ee640e93-92e3-4495-a9c5-ece1d3ac41c3','2','8','0','2023-05-10 16:04:56','2023-05-10 16:04:56');
INSERT INTO offer_products VALUES('6','3e172650-a0db-4111-a9ac-89b06e459d43','2','5','0','2023-05-10 16:04:56','2023-05-10 16:04:56');



DROP TABLE IF EXISTS offer_requests;

CREATE TABLE `offer_requests` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `offer_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `phone_number` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `remarks` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `offer_requests_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO offer_requests VALUES('1','0fa256cb-2494-4840-aa65-6d4c1fe40271','2','Rupesh Chaudhary','','9880227545','rupeshchaudhary7338@gmail.com','Individual','Ramkot Kathmandu','','2023-08-12 13:21:52','2023-08-12 13:21:52');



DROP TABLE IF EXISTS offers;

CREATE TABLE `offers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `category_id` int(11) DEFAULT NULL,
  `product_id` int(11) DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `type` varchar(255) DEFAULT NULL,
  `price` varchar(255) DEFAULT NULL,
  `summary` longtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `offers_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO offers VALUES('1','something','1','9','','Something','category','500','something','<p>something</p>','89036c5e-5f88-4488-8a2c-11d4b70ef3b0.jpg','1','2023-05-10 15:51:34','2023-05-10 15:51:34');
INSERT INTO offers VALUES('2','nothing','1','','','Nothing','product','700','nothing','<p>nothing</p>','f191b75d-c250-442f-97fa-edc1046be561.jpg','1','2023-05-10 15:52:12','2023-05-10 15:52:12');
INSERT INTO offers VALUES('3','everything','1','12','','everything','category','1300','everything','<p>everything<br></p>','8ac788a1-7021-44ff-9e51-2494973dbb75.jpg','1','2023-05-10 16:51:20','2023-08-12 12:45:41');



DROP TABLE IF EXISTS page_seos;

CREATE TABLE `page_seos` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_image` varchar(255) DEFAULT NULL,
  `seo_keyword` longtext DEFAULT NULL,
  `seo_description` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `page_seos_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO page_seos VALUES('2','contact-us','Contact Us','1','','','','','2023-08-12 12:21:05','2023-08-12 12:21:05');
INSERT INTO page_seos VALUES('3','blogs','Blogs','1','','','','','2023-08-12 12:21:21','2023-08-12 12:21:21');
INSERT INTO page_seos VALUES('4','about-us','About Us','1','','','','','2023-08-12 12:21:32','2023-08-12 12:21:32');
INSERT INTO page_seos VALUES('5','store','Store','1','','','','','2023-08-12 12:21:42','2023-08-12 12:21:42');
INSERT INTO page_seos VALUES('6','career','Career','1','','','','','2023-08-12 12:21:49','2023-08-12 12:21:49');
INSERT INTO page_seos VALUES('7','login','Login','1','','','','','2023-08-12 12:21:57','2023-08-12 12:21:57');
INSERT INTO page_seos VALUES('8','password-reset','Password Reset','1','','','','','2023-08-12 12:22:06','2023-08-12 12:22:06');
INSERT INTO page_seos VALUES('9','email-confirm','Email Confirm','1','','','','','2023-08-12 12:22:20','2023-08-12 12:22:20');
INSERT INTO page_seos VALUES('10','faqs','Faqs','1','','','','','2023-08-12 12:22:32','2023-08-12 12:22:32');
INSERT INTO page_seos VALUES('11','offers','Offers','1','','','','','2023-08-12 12:22:42','2023-08-12 12:49:19');
INSERT INTO page_seos VALUES('12','catalogues','Catalogues','1','','','','','2023-08-12 12:22:49','2023-08-12 12:22:49');
INSERT INTO page_seos VALUES('13','customer-enquiry','Customer Enquiry','1','','','','','2023-08-12 12:23:09','2023-08-12 12:23:09');
INSERT INTO page_seos VALUES('14','customer-care','Customer Care','1','','','','','2023-08-12 12:23:20','2023-08-12 12:23:20');
INSERT INTO page_seos VALUES('15','ask-your-question','Ask Your Question','1','','','','','2023-08-12 12:23:30','2023-08-12 12:23:30');
INSERT INTO page_seos VALUES('16','become-a-dealer','Become a Dealer','1','','','','','2023-08-12 12:23:44','2023-08-12 12:23:44');
INSERT INTO page_seos VALUES('17','dealer-enquiry','Dealer Enquiry','1','','','','','2023-08-12 14:26:44','2023-08-12 14:26:44');
INSERT INTO page_seos VALUES('18','reset-password','Reset Password','1','','','','','2023-08-12 17:50:05','2023-08-12 17:50:05');



DROP TABLE IF EXISTS pages;

CREATE TABLE `pages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL,
  `summary` longtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_image` varchar(255) DEFAULT NULL,
  `seo_keyword` longtext DEFAULT NULL,
  `seo_description` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `pages_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO pages VALUES('2','1','dealer-policy','Dealer Policy','<span style=\"font-family: Verdana;\">We are committed to providing a fair and level playing field for all dealers on our e-commerce platform. Our dealer policy outlines the guidelines and rules that all dealers must adhere to in order to sell products on our platform. By selling on our platform, dealers agree to abide by these policies and any violation may result in the termination of the dealer\'s account.&nbsp;</span>','<div><span style=\"color: var(--bs-card-color); font-family: Verdana; font-size: 1.25rem; text-align: var(--bs-body-text-align); font-weight: var(--bs-body-font-weight);\">Eligibility</span><br></div><div><br></div><h5><span style=\"color: var(--bs-card-color); font-family: Verdana; font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">Dealers who wish to sell products or services through our website must meet our eligibility requirements, which may include a minimum level of experience in the industry or a certain volume of sales.</span><br></h5><div><br></div><div><span style=\"font-family: Verdana; font-size: 1.25rem; color: var(--bs-card-color); text-align: var(--bs-body-text-align);\">Registration</span></div><div><span style=\"font-family: Verdana; font-size: 1.25rem; color: var(--bs-card-color); text-align: var(--bs-body-text-align);\"><br></span></div><div><span style=\"font-family: Verdana; color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">Dealers must register with our website and provide accurate and up-to-date information, including their business name, address, contact information, and tax ID number.</span></div><div><br></div><h5><span style=\"font-family: Verdana;\">Product Listings</span></h5><h5><span style=\"font-family: Verdana;\"><br></span></h5><div><span style=\"font-family: Verdana; color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">Dealers must accurately describe their products or services and provide complete and truthful information about pricing, availability, and shipping options.</span></div><div><br></div><h5><span style=\"font-family: Verdana;\">Sales and Payment</span></h5><h5><span style=\"font-family: Verdana;\"><br></span></h5><div><span style=\"font-family: Verdana; color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">Dealers are responsible for setting their own prices and handling all sales transactions with customers. All payments must be processed through our website, and we may charge a commission or transaction fee on each sale.</span></div><div><span style=\"font-family: Verdana; color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\"><br></span></div><h5><span style=\"font-family: Verdana;\">Shipping and Fulfillment</span></h5><h5><span style=\"font-family: Verdana;\"><br></span></h5><div><span style=\"font-family: Verdana; color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">Dealers are responsible for fulfilling orders and shipping products to customers in a timely and professional manner. Dealers must provide accurate shipping information and comply with our shipping policies.</span></div><div><span style=\"font-family: Verdana; color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\"><br></span></div><h5><span style=\"font-family: Verdana;\">Product Quality and Returns</span></h5><h5><span style=\"font-family: Verdana;\"><br></span></h5><div><span style=\"font-family: Verdana; color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">Dealers are responsible for the quality and accuracy of their products or services. Customers may request returns or refunds for products that do not meet their expectations or are damaged during shipping. Dealers must comply with our return policies and promptly resolve any customer complaints or disputes.</span></div><div><span style=\"font-family: Verdana; color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\"><br></span></div><h5><span style=\"font-family: Verdana;\">Termination</span></h5><h5><span style=\"font-family: Verdana;\"><br></span></h5><div><span style=\"font-family: Verdana;\">We reserve the right to terminate or suspend any dealer\'s account for any reason, including non-compliance with our policies or failure to meet our eligibility requirements.</span></div><div><br></div><h5><span style=\"font-family: Verdana;\">Changes to Policy</span></h5><h5><span style=\"font-family: Verdana;\"><br></span></h5><div><span style=\"font-family: Verdana; color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">We may update or modify this dealer policy at any time. Dealers should review the policy periodically to stay informed of any changes.</span><br></div><div><br></div>','a2744fb7-4461-4c2f-acaa-fd8e9e885b65.png','0','2023-04-27 15:16:41','2023-05-02 15:37:04','','','','');
INSERT INTO pages VALUES('3','1','privacy-policy','Privacy Policy','<div><span style=\"font-family: Verdana;\">We collect and generate various data points about you.</span></div><div><span style=\"font-family: Verdana;\">Data by which you are identified is termed as “Personal Data”. Personal Data does not mean information that is freely available or accessible in public domain.</span></div><div><span style=\"font-family: Verdana;\">Your Privacy is of utmost importance to us and protection of your Personal Data is a key commitment for us.</span></div><div><span style=\"font-family: Verdana;\">We are also governed by the provisions of applicable law in India including the Information Technology Act 2000 and the Information Technology (Reasonable security practices and procedures and sensitive personal data or information) Rules, 2011 to maintain the privacy of your Personal Data.</span></div>','<div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">I. Personal Data</span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">Personal Data we may collect from you are as under:</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">1. Personal details (e.g. name, contact details including, residential address, date of birth, documents such as identity card / passport details / Aadhaar details / PAN / Voter ID / driving license, and/or education details) provided by you to us to avail various products/services from us.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">2. Your details including transaction history, balances, payment details, for effecting transfer of monies through various payment channels provided by us.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">3. financial details (e.g. income, expenses, and/or credit history) needed as part of request for some of our products/services;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">4. images of documents/ photos required to avail any of our products/services.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">5. voice recordings of our conversations with our customer care agent with you to address your queries/grievances;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">6. employment details (e.g. occupation, positions held, employment history, salary and/or benefits) as part of our record retention for credit/various product evaluations or required under applicable law including Prevention of Money Laundering (Maintenance of Records) Rules, 2005</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">7. specimen signature(s) for processing of your instructions received by us through our various payment and delivery channels;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">8. opinions provided by you to us by way of feedback or responses to surveys;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">9. information obtained from your mobile device by way of using our app like device location, communication information including contacts and call logs, device information (including storage, model, mobile network), transactional and promotional SMS/app notifications.</span></div><div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">II. Sharing of your Personal Data</span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">Any Personal Data that we have access to shall never be shared without your consent.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">In various processes / submission of applications / availment of product/service offerings, we even seek your explicit consent to use / share your Personal Data.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">In our business and operational processes, we only share the data on a partial and “need-to-know” basis to designated personnel or partners or service providers.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">We will share your data with competent/ legal/statutory/regulatory agencies / authorities or partners/service providers acting on our behalf (as the case may be) in following cases:</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">1. only for enabling the provision of the products/services availed by you, strictly on a “need to know” basis and subject to applicable laws.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">2. it is directed or required by legal/regulatory / statutory / governmental authorities under applicable laws/regulations though a legally obligated request.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">3. it is required by financial institutions to verify, mitigate or prevent fraud or to manage risk or recover funds in accordance with applicable laws/regulations.</span></div><div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">III. Usage of Your Personal Data</span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">We use your Personal Data in our business activities for providing our or our partners’ products/services and to perform, among other actions, the following:</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">1. to facilitate the transactions or report on these transactions;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">2. to undertake research and analytics for offering or improving our products/services and their security and service quality;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">3. to check and process your applications submitted to us for products/services and/or instructions or requests received from you in respect of these products/services;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">4. to share with you, updates on changes to the products/services and their terms and conditions;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">5. to take up or investigate any complaints/claims/disputes;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">6. to respond to your queries or feedback submitted by you;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">7. to verify your identity for us to provide products/services to you;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">8. to carry credit checks, screenings or due diligence checks as lawfully required by us;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">9. to monitor and review products/services from time to time;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">10. to undertake financial/regulatory/management reporting, and create and maintain various risk management models;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">11. for conducting audits and for record keeping purposes;</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">12. for selective offers and promotions.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">External Processing: We may provide your personal information to our affiliates or other trusted businesses or persons or service providers engaged by us, or institutions that we partner with to assist us with providing you with products/services to better serve your needs and interests, based on your instructions and in compliance with our Privacy Policy and any other appropriate confidentiality and security measures.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">We also use your Personal Data to fulfill the requirements of applicable laws/regulations and/or court orders/regulatory directives received by us.</span></div><div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">IV. Purging of your Personal Data</span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">1. You may delete your Diabliss account at any point of time by making such choice in Diabliss E-commerce’s desktop website, mobile WAP site or mobile application. With this we will no longer provide your data for external processing as mentioned above. However, we retain your Personal Data as long as the purpose for its usage exists, after which the same is disposed off by us except for any record retention required as per applicable law.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">2. The provisions of various laws require your transaction logs to be stored for longer periods post the deletion of an account. Further, in the event of the pendency of any legal/regulatory proceeding or receipt of any legal and/or regulatory direction to that effect, we may be required by the law of the land to retain your Personal Data for longer periods.</span></div><h4 style=\"text-align: left;\"><br></h4><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">V. Cookie Policy</span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">1. Please note that a “cookie” is a small piece of information stored by a web server on a web browser so it can be later read back from that browser.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">2. We may use cookie and tracking technology depending on the features offered.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">3. No Personal Data will be collected via cookies and other tracking technology; however, if you previously provided Personal Data, cookies may be tied to such information.</span></div><div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">VI. Links to other websites</span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">Our website may contain links to other websites which are not maintained by us. This privacy policy only applies to us. You are requested to read the other websites’ privacy policies when visiting these websites.</span></div><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">VII. Reasonable Security Practices and Procedures</span></div><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">We take various steps and measures to protect the security of your Personal Data from misuse, loss, unauthorised access, modification or disclosure. We use latest secure server layers encryption and access control on our systems. Our safety and security processes are audited by a third party cyber security audit agency from time to time.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">We have provided multiple levels of security to safeguard your app by Login/Logout option and AppLock feature that can be enabled by you. We also ensure the device binding so that the same login cannot be used on different device without any additional authentication/OTP. Please do not share your Diabliss login, password and OTP details with anybody.</span></div><h5><div style=\"text-align: left;\"><br></div><span style=\"font-family: Verdana;\"><div style=\"text-align: left;\"><span style=\"font-family: Verdana; font-size: 1.25rem; color: var(--bs-card-color); text-align: var(--bs-body-text-align);\">VIII. Contact us</span></div></span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">You may contact us on any aspect of this policy or for any discrepancies/grievances with respect to your Personal Data, by writing to our Grievance Officer at Diabliss Consumer Products Pvt Ltd, Type II/20, Dr.VSI Estate, Thiruvanmiyur, Chennai – 600041, Tamilnadu, INDIA</span></div><div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">IX. Policy Review &amp; Updates</span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">This policy will be reviewed by us as and when required and the same may change at any time. The latest &amp; most updated policy can always be found at https://Diabliss.in/privacy-policy/ While we will make reasonable efforts to keep you posted on any updates to this privacy policy, to make sure that you are aware of any changes, we recommend that you review this policy periodically.</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">This Privacy Policy shall apply uniformly to Diabliss E-commerce’s desktop website, mobile WAP site &amp; mobile applications</span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">In this policy, the words “we”, “ours” and/or “us” refer to Diabliss E-commerce Private Limited and “you” and/or “your” refer to our customers.</span></div><div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">X. Cancellation ( Applicable Before service use )</span></h5><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\"><br></span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\"> In 1 day customers can initiated the cancellation &amp; once cancellation is approved within 3 days refund will be processed and in 7-10 working days amount would be reflected&nbsp; in customer’s bank account</span></div><div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">XI. Refund&nbsp; &nbsp;( Applicable After&nbsp; service use )</span></h5><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\"><br></span></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">&nbsp; &nbsp;In 1 days&nbsp; customers can initiated the Refund &amp; once refund is&nbsp; approved&nbsp; within 3 days refund will be processed and in 7-10 working days amount would be reflected&nbsp; in customer’s bank account</span></div>','0a0f5d94-ebf1-4343-be07-f4e701083daa.png','0','2023-04-27 15:17:31','2023-05-02 15:59:04','','','','');
INSERT INTO pages VALUES('4','1','payment-policy','Payment Policy','<span style=\"font-family: Verdana;\">We are committed to providing a secure and hassle-free payment experience for our customers on our e-commerce platform. Our payment policy outlines the guidelines and rules that govern payments on our platform.</span>','<div><div><br></div><div><br></div><h5><span style=\"font-family: Verdana;\">Payment Security</span></h5><h5><span style=\"color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\"><br></span></h5><h5><span style=\"color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">We use industry-standard encryption technology to ensure the security of all payment transactions on our platform. We do not store any credit card information on our servers and all payments are processed by third-party payment processors.</span><br></h5><div><br></div><h5><span style=\"font-family: Verdana;\">Payment Authorization</span></h5><div><br></div><div><span style=\"font-family: Verdana;\">All payments must be authorized by the customer before the order is processed. We reserve the right to cancel any order that is not authorized by the customer or that we suspect may be fraudulent.</span></div><div><br></div><h5><span style=\"font-family: Verdana;\">Payment Processing Time</span></h5><div><br></div><div><span style=\"font-family: Verdana;\">Payments are processed immediately upon authorization. In some cases, it may take up to 24 hours for the payment to be fully processed and for the order to be confirmed. Once the payment is processed, the order cannot be cancelled.</span></div><div><br></div><h5><span style=\"font-family: Verdana;\">Payment Disputes</span></h5><div><br></div><div><span style=\"font-family: Verdana;\">In the event of a payment dispute, customers should contact our customer service team immediately. We will work to resolve the issue as quickly and fairly as possible. If a dispute cannot be resolved, we may initiate a chargeback process with the payment processor.</span></div><div><br></div><h5><span style=\"font-family: Verdana;\">Refunds and Returns</span></h5><div><br></div><div><span style=\"font-family: Verdana;\">We have a separate refund and return policy, which outlines the guidelines and rules for requesting refunds and returning products. Customers should refer to this policy for information on how to request a refund or return.</span></div><div><br></div><h5><span style=\"font-family: Verdana;\">Taxes and Fees</span></h5><div><br></div><div><span style=\"font-family: Verdana;\">Customers are responsible for paying any applicable taxes or fees associated with their order, including sales tax, VAT, customs duties, and shipping fees. These fees will be clearly listed at checkout.</span></div><div><br></div><div><br></div><div><span style=\"font-family: Verdana;\">We reserve the right to update or modify our payment policy at any time without prior notice. By using our e-commerce platform, customers agree to comply with our payment policy and any updates or changes made to it in the future.</span></div></div>','634b54bb-fc45-4440-ac6d-38aef6209a8e.png','0','2023-04-27 15:18:35','2023-05-02 16:01:31','','','','');
INSERT INTO pages VALUES('5','1','terms-and-condition','Terms & Condition','<h5 style=\"text-align: justify;\"><span style=\"font-family: Verdana;\">﻿</span><span style=\"font-family: Verdana;\">Use of the Platform or Services</span></h5><div style=\"text-align: justify;\"><br></div><div style=\"text-align: justify;\"><span style=\"font-family: Verdana;\">Please read the following terms and conditions carefully before registering on, accessing, browsing, downloading or using the Diabliss Consumer Products Pvt Ltd website located at www.diabliss.in, and all associated sites linked to www.diabliss.in, or any similar platform (hereinafter collectively, the Diabliss Consumer Products Pvt Ltd Platform.</span></div>','<h6><br></h6><div style=\"text-align: left;\">It has&nbsp; its registered office at Type II/20, Dr.VSI Estate, Thiruvanmiyur, Chennai – 600041, Tamilnadu, INDIA on any device and/or before availing any services offered by Diabliss Consumer Products Pvt Ltd on the Diabliss Consumer Products Pvt Ltd Platform which may include services such as donation or contribution or any other service that may be offered by Diabliss Consumer Products Pvt Ltd on the Diabliss Consumer Products Pvt Ltd Platform (hereinafter individually, and collectively, the Diabliss Consumer Products Pvt Ltd Services). For the avoidance of doubt, it is clarified that these terms and conditions shall apply to all Our Services, whether offered by Diabliss Consumer Products Pvt Ltd.</div><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><h5><span style=\"font-family: Verdana; font-size: 1.25rem; color: var(--bs-card-color);\">Indemnification</span></h5><h5><span style=\"font-family: Verdana; font-size: 1.25rem; color: var(--bs-card-color);\"><br></span></h5></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">You agree to indemnify, save, and hold Diabliss Consumer Products Pvt Ltd, its affiliates, employees, officers, directors and partners harmless from any and all claims, losses, damages, and liabilities, costs and expenses, including without limitation legal fees and expenses, arising out of or related to:</span></div><div style=\"text-align: left;\">(i) Your use or misuse of the Diabliss Consumer Products Pvt Ltd Services or of the Diabliss Consumer Products Pvt Ltd Platform;</div><div style=\"text-align: left;\">(ii) any violation by You of this Agreement or the SSOID Agreement; or</div><div style=\"text-align: left;\">(iii) any breach of the representations, warranties, and covenants made by You herein.</div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">Diabliss Consumer Products Pvt Ltd reserves the right, at Your expense, to assume the exclusive defense and control of any matter for which You are required to indemnify Diabliss Consumer Products Pvt Ltd, including rights to settle, and You agree to cooperate with we defense and settlement of these claims. We will use reasonable efforts to notify You of any claim, action, or proceeding brought by a third party that is subject to the foregoing indemnification upon becoming aware of it. This paragraph shall survive termination of this Agreement.</span></div><div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">Disclaimer; No Warranties</span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">To the fullest extent permissible pursuant to applicable law, Diabliss Consumer Products Pvt Ltd and its third-party partners disclaim all warranties or guarantees – whether statutory, express or implied – including, but not limited to, implied warranties of merchantability, fitness for a particular purpose, and non-infringement of proprietary rights. No advice or information, whether oral or written, obtained by You from Diabliss Consumer Products Pvt Ltd or through the Diabliss Consumer Products Pvt Ltd Services or the Diabliss Consumer Products Pvt Ltd Platform will create any warranty or guarantee other than those expressly stated herein. For the purposes of this Disclaimer,</span> <span style=\"font-family: Verdana;\">You expressly acknowledge that as used in this section, the term “Diabliss Consumer Products Pvt Ltd” includes Diabliss Consumer Products Pvt Ltd’s officers, directors, employees. You acknowledge that Diabliss Consumer Products Pvt Ltd (www.diabliss.in) is not liable for any third party (telecom companies, mobile operators or suppliers) obligations due to rates, quality and all other instances, whether to any such telecom companies’ subscribers or otherwise.</span> <span style=\"font-family: Verdana;\">You expressly agree that the use of the Diabliss Consumer Products Pvt Ltd Services on our Platform is at Your sole risk. It is Your responsibility to evaluate the accuracy, completeness and usefulness of all opinions, advice, services, merchandise and other information provided through the site or on the Internet generally. We do not warrant that our Services will be uninterrupted or error-free or that defects in the site will be corrected. The Diabliss Consumer Products Pvt</span><span style=\"font-family: Verdana;\"> Ltd Services and our Platform and any data, information, third party software, reference sites, services, or software made available in conjunction with or through the services and the site are provided on an “as is” and “as available,” “with all faults” basis and without warranties or representations of any kind either express or implied. Diabliss Consumer Products Pvt Ltd, and its partners do not warrant that the data, our software, functions, or any other information offered on or through our Services/</span><span style=\"font-family: Verdana;\"> our Platform or any reference sites/ platforms/ services will be uninterrupted, or free of errors, viruses or other harmful components and do not warrant that any of the foregoing will be corrected. Diabliss Consumer Products Pvt Ltd and its licensors, and partners do not warrant or make any representations regarding the use or the results of the use of Our Services/ Our Platform or any reference sites/ platforms/ services in terms of correctness, accuracy, reliability, or otherwise. You understand and agree that You use, access, download, or otherwise obtain information, materials, or data through Our Services/ Our Platform or any reference sites/ platforms/ services at Your own discretion and risk and that You will be solely responsible for any damage to Your property (including Your computer system and mobile device or any other equipment) or loss of data that results from the download or use of such material or data. We do not authorize anyone to make any <span style=\"font-family: Verdana;\">w</span></span><span style=\"font-family: Verdana;\">arranty on our behalf and You should not rely on any such statement. This paragraph shall survive the termination of this Agreement. In no event will Diabliss Consumer Products Pvt Ltd be liable for any incidental, consequential, or indirect damages (including, but not limited to, damages for loss of profits, business interruption, loss of programs or information and the like) arising out of the use of or inability to use Our Platform.</span></div><div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">Ownership; Proprietary Rights</span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">The Diabliss Consumer Products Pvt Ltd Services and Our Platform are owned and operated by Diabliss Consumer Products Pvt Ltd for Social Welfare. The visual interfaces, graphics, design, compilation, information, computer code (including source code and object code), services, and all other elements of Our Services and Our Platform provided by Diabliss Consumer Products Pvt Ltd for Social Welfare are protected by international conventions, and all other relevant intellectual property and proprietary rights, and applicable laws. As between You and Diabliss Consumer Products Pvt Ltd, all services and programs contained on Our are the property of Diabliss Consumer Products Pvt Ltd for Social Welfare. You agree not to remove, obscure, or alter Anudip or any third party’s copyright, patent, trademark, or other proprietary rights notices affixed to or contained within or accessed in conjunction with or through Our Services/ Platform. Except as expressly authorized by Diabliss Consumer Products Pvt Ltd, You agree not to sell, license, distribute, copy, modify, publicly perform or display, transmit, publish, edit, adapt, create derivative works from, or otherwise make unauthorized use of the services. Diabliss Consumer Products Pvt Ltd reserves all rights not expressly granted in this Agreement. If You have comments regarding Our Services and/or Our Platform or ideas on how to improve it, please contact customer service. Please note that by doing so, You hereby irrevocably assign to Diabliss Consumer Products Pvt Ltd, and shall assign to Diabliss Consumer Products Pvt Ltd, all rights, title and interests in and to all ideas and suggestions and any and all worldwide intellectual property rights associated therewith. You agree to perform such acts and execute such documents as may be reasonably necessary to perfect the foregoing rights.</span></div><div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">Dispute Resolution</span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">If any dispute, controversy or claim arises under this Agreement or in relation to any Diabliss Consumer Products Pvt Ltd Service or our Platform, including any question regarding the existence, validity or termination of this Agreement or T&amp;Cs (hereinafter Dispute), the parties shall use all reasonable endeavors to resolve such Dispute amicably. If the parties are unable to resolve the Dispute amicably within 30 days of the notice of such Dispute, Diabliss Consumer Products Pvt Ltd may elect to resolve any Dispute by binding arbitration in accordance with the provisions of the Indian Arbitration &amp; Conciliation Act, 1996 (hereinafter Act). Such Dispute shall be arbitrated on an individual basis and shall not be consolidated in any arbitration with any claim or controversy of any other party. The Dispute shall be resolved by a sole arbitrator, appointed in accordance with the Act. The seat of the arbitration shall be New Delhi and the language of this arbitration shall be English. Either You or Anudip may seek any interim or preliminary relief from a court of competent jurisdiction in Kolkata necessary to protect the rights or the property belonging to You or Diabliss Consumer Products Pvt Ltd (or any of our agents, suppliers, and subcontractors), pending the completion of arbitration. Any arbitration shall be confidential, and neither You nor Diabliss Consumer Products Pvt Ltd may disclose the existence, content, or results of any arbitration, except as may be required by law or for purposes of enforcing the arbitration award. All administrative fees and expenses of arbitration will be divided equally between You and Diabliss Consumer Products Pvt Ltd. In all arbitrations, each party will bear the expense of its own lawyers and preparation. This paragraph shall survive termination of this Agreement.</span></div><div style=\"text-align: left;\"><br></div><h5 style=\"text-align: left;\"><span style=\"font-family: Verdana;\">Governing Law and Forum for Disputes</span></h5><div style=\"text-align: left;\"><br></div><div style=\"text-align: left;\"><span style=\"font-family: Verdana;\">Subject to the Dispute Resolution section above, You agree that any claim or dispute You may have against Diabliss Consumer Products Pvt Ltd must be resolved by a court having jurisdiction in Chennai, India. You agree to submit to the personal jurisdiction of the courts located within Chennai, India, for the purpose of litigating all such claims or disputes. This Agreement shall be governed by Indian law. This paragraph shall survive termination of this Agreement.</span></div>','45fe7ae3-f5de-4103-92e2-a31424cc92f1.png','0','2023-04-27 15:19:04','2023-05-07 08:43:17','','','','');



DROP TABLE IF EXISTS password_resets;

CREATE TABLE `password_resets` (
  `email` varchar(255) NOT NULL,
  `token` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO password_resets VALUES('rupeshchaudhary7338@gmail.com','$2y$10$GGR4EtuWH15pPtQ1SXZyQ.VDlZSsLin7SpiM64esg/D/ihvWMmDci','2023-08-13 10:37:58');



DROP TABLE IF EXISTS permissions;

CREATE TABLE `permissions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `permissions_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=130 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO permissions VALUES('1','role-list','web','2023-08-14 10:33:42','2023-08-14 10:33:42');
INSERT INTO permissions VALUES('2','role-create','web','2023-08-14 10:33:42','2023-08-14 10:33:42');
INSERT INTO permissions VALUES('3','role-edit','web','2023-08-14 10:33:42','2023-08-14 10:33:42');
INSERT INTO permissions VALUES('4','role-delete','web','2023-08-14 10:33:42','2023-08-14 10:33:42');
INSERT INTO permissions VALUES('5','client-list','web','2023-08-14 10:33:42','2023-08-14 10:33:42');
INSERT INTO permissions VALUES('6','client-create','web','2023-08-14 10:33:42','2023-08-14 10:33:42');
INSERT INTO permissions VALUES('7','client-edit','web','2023-08-14 10:33:42','2023-08-14 10:33:42');
INSERT INTO permissions VALUES('8','client-delete','web','2023-08-14 10:33:42','2023-08-14 10:33:42');
INSERT INTO permissions VALUES('9','category-list','web','2023-08-14 10:33:42','2023-08-14 10:33:42');
INSERT INTO permissions VALUES('10','category-create','web','2023-08-14 10:33:42','2023-08-14 10:33:42');
INSERT INTO permissions VALUES('11','category-edit','web','2023-08-14 10:33:42','2023-08-14 10:33:42');
INSERT INTO permissions VALUES('12','category-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('13','product-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('14','product-create','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('15','product-edit','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('16','product-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('17','unit-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('18','unit-create','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('19','unit-edit','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('20','unit-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('21','product-import','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('22','product-export','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('23','page-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('24','page-create','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('25','page-edit','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('26','page-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('27','job-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('28','job-create','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('29','job-edit','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('30','job-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('31','candidate-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('32','candidate-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('33','general-setting','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('34','email-send','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('35','email-history','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('36','email-setting','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('37','news-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('38','news-edit','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('39','news-create','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('40','news-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('41','testimonial-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('42','testimonial-create','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('43','testimonial-edit','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('44','testimonial-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('45','faq-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('46','faq-edit','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('47','faq-create','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('48','faq-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('49','faq-type-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('50','faq-type-edit','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('51','faq-type-create','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('52','faq-type-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('53','faq-request-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('54','faq-request-show','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('55','faq-request-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('56','setting-general','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('57','dealer-request-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('58','dealer-request-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('59','dealer-enquiry-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('60','dealer-enquiry-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('61','customer-enquiry-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('62','customer-enquiry-delete','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('63','offer-list','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('64','offer-create','web','2023-08-14 10:33:43','2023-08-14 10:33:43');
INSERT INTO permissions VALUES('65','offer-edit','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('66','offer-show','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('67','offer-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('68','offer-product-status','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('69','offer-product-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('70','offer-request-list','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('71','offer-request-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('72','product-request-list','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('73','product-request-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('74','plugin-list','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('75','plugin-create','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('76','plugin-edit','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('77','plugin-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('78','catalogue-list','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('79','catalogue-create','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('80','catalogue-edit','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('81','catalogue-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('82','subscriber-list','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('83','subscriber-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('84','contact-us-list','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('85','contact-us-show','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('86','contact-us-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('87','complain-list','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('88','complain-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('89','complain-type-list','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('90','complain-type-create','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('91','complain-type-edit','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('92','complain-type-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('93','blog-list','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('94','blog-create','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('95','blog-edit','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('96','blog-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('97','blog-category-list','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('98','blog-category-create','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('99','blog-category-edit','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('100','blog-category-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('101','user-list','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('102','user-create','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('103','user-edit','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('104','user-delete','web','2023-08-14 10:33:44','2023-08-14 10:33:44');
INSERT INTO permissions VALUES('105','shop-list','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('106','shop-create','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('107','shop-edit','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('108','shop-delete','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('109','about-page-list','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('110','about-page-create','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('111','about-page-edit','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('112','about-page-delete','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('113','quality-list','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('114','quality-create','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('115','quality-edit','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('116','quality-delete','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('117','buy-method-list','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('118','buy-method-create','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('119','buy-method-edit','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('120','buy-method-delete','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('121','seo-list','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('122','seo-create','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('123','seo-edit','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('124','seo-delete','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('125','admin-backup','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('126','admin-setting','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('127','admin-notification','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('128','admin-mail','web','2023-08-14 10:33:45','2023-08-14 10:33:45');
INSERT INTO permissions VALUES('129','admin-utilities','web','2023-08-14 10:33:45','2023-08-14 10:33:45');



DROP TABLE IF EXISTS personal_access_tokens;

CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `token` varchar(64) NOT NULL,
  `abilities` text DEFAULT NULL,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS plugins;

CREATE TABLE `plugins` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `code` longtext NOT NULL,
  `type` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `plugins_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO plugins VALUES('5','d296a609-a7bb-43de-add2-d0bf9744dec1','1','Google Analytics','<!-- Google tag (gtag.js) -->
<script async src=\"https://www.googletagmanager.com/gtag/js?id=G-MCFKL3PT75\"></script>
<script>
  window.dataLayer = window.dataLayer || [];
  function gtag(){dataLayer.push(arguments);}
  gtag(\'js\', new Date());

  gtag(\'config\', \'G-MCFKL3PT75\');
</script>','Header','1','2023-05-27 15:25:31','2023-05-27 15:25:31');



DROP TABLE IF EXISTS product_requests;

CREATE TABLE `product_requests` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `product_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `company_name` varchar(255) DEFAULT NULL,
  `phone_number` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `type` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `remarks` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `product_requests_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO product_requests VALUES('1','02edc60d-5676-4b59-8a34-7189cb1652e0','7','Rupesh Chaudhary','','9880227545','rupeshchaudhary7338@gmail.com','Individual','Ramkot, Kathmandu','','2023-05-12 13:17:42','2023-05-12 13:17:42');
INSERT INTO product_requests VALUES('2','a0d0118d-b369-46ab-82d0-8a329e5acb4c','9','sanskar pokhrel','','7894561230','sanskarpokharel@gmail.com','Individual','BUdanilkantha-10, Kathmandu','hi how are you','2023-05-17 13:11:09','2023-05-17 13:11:09');
INSERT INTO product_requests VALUES('3','ae9e36e1-ed14-4b58-8400-56b181ff9e23','6','645 4yrt','','7894561230','bvc@gng.ccmc','Individual','hglhm','','2023-05-23 10:31:47','2023-05-23 10:31:47');
INSERT INTO product_requests VALUES('4','bf2086a2-1a46-415d-8b85-23c060e40700','14','Pennada Surya Venkata Rama Mohana Rao','','9493547913','pennadaramamohan@gmail.com','Individual','85-50-2, plot no.59, model colony, Rajahmundry','Required one bottle','2023-07-24 19:15:50','2023-07-24 19:15:50');



DROP TABLE IF EXISTS products;

CREATE TABLE `products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `category_id` int(11) NOT NULL,
  `in_stock` int(11) NOT NULL DEFAULT 1,
  `mrp_price` varchar(255) NOT NULL,
  `offer_price` varchar(255) DEFAULT NULL,
  `dealer_price` varchar(255) DEFAULT NULL,
  `retailer_price` varchar(255) DEFAULT NULL,
  `discount_price` varchar(255) DEFAULT NULL,
  `image` varchar(255) DEFAULT NULL,
  `summary` longtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `seo_title` varchar(255) DEFAULT NULL,
  `seo_image` varchar(255) DEFAULT NULL,
  `seo_keyword` longtext DEFAULT NULL,
  `seo_description` longtext DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `weight` varchar(255) DEFAULT NULL,
  `unit` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `products_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO products VALUES('4','diabliss-jagger-jar-750g','1','Diabliss Jaggery Jar 750g','1','99','0','','','0','','0b5974da-7304-4c72-a580-7bef0844eed6.webp','','<p>Diabliss has created a revolution by launching the world’s 1st low glycemic index sugar. Diabliss has now extended this innovation to jaggery powder. Many consumers these days are preferring jaggery to cane sugar but are also concerned with blood sugar rise, hygiene, and ease of use.<br></p>','Diabliss Jaggery Jar 750g','','Diabliss Jaggery Jar 750g','Diabliss Jaggery Jar 750g','0','2023-05-08 13:10:54','2023-05-23 14:45:02','','Select One');
INSERT INTO products VALUES('5','diabliss-mixed-fruit-jam-225g','1','Diabliss Mixed Fruit Jam 225g','14','99','0','','','0','','9723c4bb-ed5f-4b90-8af6-f4a8fb14df5a.webp','','<p>Diabliss adds to its growing range of sugar-free products with Diabliss Mixed Fruit Jam, a healthy and tasty jam. This delicious mixed fruit jam can be applied to bread and rotis for a delicious snack. As it is made with Diabliss Herbal Sugar, the product is diabetic-friendly and a low glycemic index food. Diabliss Mixed Fruit Jam’s glycemic index value is as low as 50 – which cannot be matched by other jams in the market!<br></p>','Diabliss Mixed Fruit Jam 225g','','Diabliss Mixed Fruit Jam 225g','Enjoy the delightful taste of Diabliss Mixed Fruit Jam 225g. Bursting with the goodness of mixed fruits, this jam is a perfect blend of flavors and health benefits. Made with natural ingredients and without any added sugars, Diabliss Mixed Fruit Jam is a guilt-free choice for your breakfast or snacks. The convenient 225g jar ensures freshness and easy usage. Elevate your taste buds with the delectable Diabliss Mixed Fruit Jam 225g and savor the goodness of nature\'s sweetness.','1','2023-05-08 13:13:07','2023-05-23 14:47:09','','Select One');
INSERT INTO products VALUES('6','diabliss-herbal-lemon-tea-500g','1','Diabliss Herbal Lemon Tea 500g','13','99','0','','','0','','681fd75d-842d-41c6-8182-b07e581d5209.webp','','<p>Diabliss Herbal Lemon Tea will enliven your mornings in a healthy and wholesome way. This pre-mix tea brings together the freshest tea powder, zesty lemon flavour and Diabliss’ diabetic friendly sugar. So it’s made from all things good! Just add hot or cold water and your tasty herbal lemon tea is ready. This product is ideal for diabetics, prediabetics and health-conscious individuals.</p><p><br></p>','Diabliss Herbal Lemon Tea 500g','','Diabliss Herbal Lemon Tea 500g','Experience the refreshing and revitalizing Diabliss Herbal Lemon Tea 500g. Crafted with a blend of herbal ingredients and zesty lemon, this tea offers a soothing and invigorating beverage option. With its natural antioxidants and therapeutic properties, Diabliss Herbal Lemon Tea provides a healthy and delicious way to unwind. The convenient 500g pack ensures you have an ample supply to enjoy throughout the day. Discover the perfect harmony of flavors in Diabliss Herbal Lemon Tea 500g and indulge in a revitalizing tea experience.','1','2023-05-08 13:15:28','2023-05-23 14:49:24','500','gm');
INSERT INTO products VALUES('7','diabliss-masala-chai-100g','1','Diabliss Masala Chai 100g','13','10','0','','','0','','6301dd50-703d-42b8-932e-4dfeebaac025.webp','','<p>Diabliss launches a perfect and natural tea for diabetics and prediabetics with Diabliss Masala Chai. It is a premixed tea that can be enjoyed by just adding either hot water or milk to it. This ready to drink tea is appropriate for diabetics and prediabetics because it is scientifically proven to maintain blood glucose at optimal levels.<br></p>','Diabliss Masala Chai 100g','','Diabliss Masala Chai 100g','Indulge in the rich and aromatic Diabliss Masala Chai 100g. This delightful blend of premium tea leaves and authentic Indian spices creates a perfect balance of flavors and warmth. Experience the traditional taste of masala chai infused with Diabliss\' unique touch. The convenient 100g pack allows you to enjoy the authentic masala chai experience at home or on the go. Sip and savor the aromatic essence of Diabliss Masala Chai 100g and immerse yourself in the delightful flavors of India.','1','2023-05-08 13:16:53','2023-05-23 14:54:43','','Select One');
INSERT INTO products VALUES('8','diabliss-sugar-500g','1','Diabliss Sugar 500g','11','10','0','','','0','','ad7096f8-a218-4e41-ac06-3b68582b0547.webp','','<p>Diabliss Herbal Sugar has created a revolution by launching the world’s 1st low glycemic index sugar. This herbal sugar is a diabetic friendly product that can be consumed by patients with diabetes, prediabetics and health conscious individuals. Comprehensive testing and scientific clinical trials have proven that Diabliss Herbal Sugar is ideal for diabetics as it doesn’t cause an unhealthy surge in blood sugar levels. Diabliss Product is sugar free for diabetics, people can make the best sugar-free food that they desire like desserts, beverages, etc. without feeling guilty and maintaining good health.</p><p><br></p>','Diabliss Sugar 500g','','Diabliss Sugar 500g','Upgrade your sweetening choices with Diabliss Sugar 500g. This premium-quality sugar is thoughtfully crafted to provide a healthier alternative to traditional sweeteners. With its low glycemic index and rich taste, Diabliss Sugar allows you to indulge in sweetness without compromising on your health. The convenient 500g pack ensures you have a versatile and long-lasting supply for your culinary needs. Elevate your recipes and beverages with the goodness of Diabliss Sugar 500g and embrace a healthier way to satisfy your sweet cravings.','1','2023-05-08 13:23:06','2023-05-23 14:59:33','500','gm');
INSERT INTO products VALUES('9','diabliss-ginger-tea-100g','1','Diabliss Ginger Tea 100g','13','10','0','','','0','','708da19a-f287-437c-aabc-94f5c1ce130b.webp','','<p>Diabliss launches a tea for diabetes that has an organic, zestful flavor and doesn’t elevate blood glucose levels. Presenting Diabliss Ginger Tea – a perfect blend of ginger flavor, aromatic tea goodness, and Diabliss Herbal Sugar. It is fit for consumption for prediabetics, diabetics, and wellness conscious individuals.<br></p>','Diabliss Ginger Tea 100g','','Diabliss Ginger Tea 100g','Awaken your senses with the aromatic and invigorating Diabliss Ginger Tea 100g. Infused with the natural goodness of ginger, this tea provides a delightful combination of flavors and health benefits. Savor the soothing warmth and distinctive taste of ginger while enjoying the numerous therapeutic properties it offers. The convenient 100g pack allows you to conveniently enjoy the revitalizing goodness of Diabliss Ginger Tea. Experience the invigorating blend of flavors in Diabliss Ginger Tea 100g and embark on a refreshing tea journey.','1','2023-05-08 13:43:18','2023-05-23 14:52:00','100','gm');
INSERT INTO products VALUES('10','herbal-water-to manage-blood-glucose','1','Diabliss Herbal Water to Manage Blood Glucose','3','10','0','','','0','','b913adbd-927d-4104-b949-68647fc5b7b1.webp','','<p><br></p><p>Diabliss formulated a multi-component herbal system using food-based herbs and spices to manage blood glucose.<span style=\"color: var(--bs-card-color); font-size: var(--bs-body-font-size); font-weight: var(--bs-body-font-weight); text-align: var(--bs-body-text-align);\">The ingredients used in Diabliss herbal water formulation are well known for their antidiabetic, anti-inflammatory, anti-hyper lipidemic activity compounds. These ingredients are also known to contain actives that slow down glucose absorption, enhance insulin secretion &amp; increase insulin sensitivity.</span></p>','Diabliss Herbal Water to Manage Blood Glucose','','Diabliss Herbal Water to Manage Blood Glucose','','1','2023-05-08 14:09:25','2023-05-23 13:44:47','','Select One');
INSERT INTO products VALUES('11','diabliss-herbal-waters-to-nurture-healthy-skin','1','Diabliss Herbal Waters to Nurture Healthy Skin','2','10','0','','','0','','154a410e-fef8-4d3d-8415-4ff116e90b21.webp','','<p>Everybody would love to have the perfect skin. And the best way to get it is by regularly using Diabliss Herbal Water Supplement for Skin care. Made with carefully chosen herbs, it is clinically tested and scientifically proven. It is found to deliver outstanding results in all aspects of skin care including skin elasticity, wrinkles, texture, hydration, glow, spots reduction and complexion. Each bottle contains one month supply.<br></p>','Diabliss Herbal Waters to Nurture Healthy Skin','','Diabliss Herbal Waters to Nurture Healthy Skin','Discover the nourishing benefits of Diabliss Herbal Waters for healthy skin. Enriched with natural ingredients, Diabliss Herbal Waters offer a refreshing and hydrating solution to promote skin health from within. Packed with antioxidants and essential nutrients, these herbal waters help rejuvenate and nurture your skin. Experience the rejuvenating power of herbal remedies in a convenient and delicious drink. Incorporate Diabliss Herbal Waters into your daily routine and let your skin glow with vitality.','1','2023-05-08 14:15:24','2023-05-23 14:57:34','','Select One');
INSERT INTO products VALUES('12','diabliss-herbal-water-for-enhancing-healthy-hair','1','Diabliss Herbal Water for Enhancing Healthy Hair','9','10','0','','','0','','a00f74a8-5dce-46d8-8304-ab0cdb6811fc.webp','','<p>If you have problems of hair fall, hair density, hair texture, hair shine, hair body, hair strength, hair coverage, then this Diabliss Herbal Water Supplement is just for you. It is clinically tested &amp; scientifically proven to deliver outstanding results in all aspects of hair care. Suitable for both men and women. Each bottle contains one month supply.</p><p><br></p>','something','','something','something','1','2023-05-08 14:18:44','2023-05-23 14:44:17','','Select One');
INSERT INTO products VALUES('14','diabliss-sugar-jar-1kg','1','Diabliss Sugar Jar 1kg','11','10','0','','','0','','316ffd4e-31af-47b1-832a-bf664d7ab982.webp','','<p>DiaBliss offers Diabetes Jar 1kg sugar – which is excellent for controlling blood sugar. Diabliss Herbal Sugar has created a revolution by launching the world’s 1st low glycemic index sugar. This herbal sugar is a diabetic friendly product that can be consumed by diabetes patients, prediabetics and health conscious individuals. Comprehensive testing and scientific clinical trials have proven that Diabliss Herbal Sugar is ideal for diabetics as it doesn’t cause an unhealthy surge in blood sugar levels. Diabliss Product is sugar free for diabetics, people can make the best sugar-free food that they desire like desserts, beverages, etc. without feeling guilty and maintaining good health.<br></p>','Diabliss Sugar Jar 1kg','','Diabliss Sugar Jar 1kg','Elevate your sweetening experience with Diabliss Sugar Jar 1kg. This premium sugar is carefully crafted to provide a healthier alternative to traditional sweeteners. With its low glycemic index and natural goodness, Diabliss Sugar helps manage your sugar intake without compromising on taste. The convenient 1kg jar ensures you have an ample supply of this versatile sweetener for all your culinary creations. Enhance the flavor of your favorite recipes and beverages with Diabliss Sugar Jar 1kg and make a conscious choice for your overall well-being.','1','2023-05-08 14:22:27','2023-05-23 15:00:28','1','kg');



DROP TABLE IF EXISTS qualities;

CREATE TABLE `qualities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `summary` longtext NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `qualities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO qualities VALUES('1','9e1a0de3-3b9f-49f4-b09a-89d4348cda60','1','100 % pure','We emphasize avoiding the addition of any artificial additives or fillers.','9219a001-e84f-4ff8-bfc0-a7466f6282fd.webp','1','2023-05-17 08:36:10','2023-05-17 15:00:00');
INSERT INTO qualities VALUES('2','06261ef8-5a74-4587-91fa-0a529c638ccd','1','Organic','We strive to source ingredients that are derived from nature, such as fruits, vegetables, whole grains, and herbs  that makes healthy eating for diabetics.','189415a1-bf68-4f81-96d8-0568bc47c477.webp','1','2023-05-17 08:36:27','2023-06-08 10:40:03');
INSERT INTO qualities VALUES('3','c7e0e297-78b9-4000-974b-eb7ed0c55728','1','Extraction','Our products involves the extraction of specific natural components from their our ingredients to make diabetes-friendly foods.','ed8211af-7349-4fc5-91e5-57a3ffbf279e.webp','1','2023-05-17 08:36:46','2023-06-08 10:39:11');
INSERT INTO qualities VALUES('4','dc7e4255-3ba4-480d-8e91-78b4a49bfc8a','1','Quality Manufacturing','We ensure quality manufacturing of diabetes diet through good practices, rigorous quality control, and high-quality ingredient sourcing.','b021847e-5d13-4239-880e-2149cf1692eb.webp','1','2023-05-17 08:37:07','2023-06-08 10:37:39');



DROP TABLE IF EXISTS role_has_permissions;

CREATE TABLE `role_has_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL,
  `role_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`permission_id`,`role_id`),
  KEY `role_has_permissions_role_id_foreign` (`role_id`),
  CONSTRAINT `role_has_permissions_permission_id_foreign` FOREIGN KEY (`permission_id`) REFERENCES `permissions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `role_has_permissions_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO role_has_permissions VALUES('1','1');
INSERT INTO role_has_permissions VALUES('1','2');
INSERT INTO role_has_permissions VALUES('2','1');
INSERT INTO role_has_permissions VALUES('2','2');
INSERT INTO role_has_permissions VALUES('3','1');
INSERT INTO role_has_permissions VALUES('3','2');
INSERT INTO role_has_permissions VALUES('4','1');
INSERT INTO role_has_permissions VALUES('4','2');
INSERT INTO role_has_permissions VALUES('5','1');
INSERT INTO role_has_permissions VALUES('5','2');
INSERT INTO role_has_permissions VALUES('6','1');
INSERT INTO role_has_permissions VALUES('6','2');
INSERT INTO role_has_permissions VALUES('7','1');
INSERT INTO role_has_permissions VALUES('7','2');
INSERT INTO role_has_permissions VALUES('8','1');
INSERT INTO role_has_permissions VALUES('8','2');
INSERT INTO role_has_permissions VALUES('9','1');
INSERT INTO role_has_permissions VALUES('9','2');
INSERT INTO role_has_permissions VALUES('10','1');
INSERT INTO role_has_permissions VALUES('10','2');
INSERT INTO role_has_permissions VALUES('11','1');
INSERT INTO role_has_permissions VALUES('11','2');
INSERT INTO role_has_permissions VALUES('12','1');
INSERT INTO role_has_permissions VALUES('12','2');
INSERT INTO role_has_permissions VALUES('13','1');
INSERT INTO role_has_permissions VALUES('13','2');
INSERT INTO role_has_permissions VALUES('14','1');
INSERT INTO role_has_permissions VALUES('14','2');
INSERT INTO role_has_permissions VALUES('15','1');
INSERT INTO role_has_permissions VALUES('15','2');
INSERT INTO role_has_permissions VALUES('16','1');
INSERT INTO role_has_permissions VALUES('16','2');
INSERT INTO role_has_permissions VALUES('17','1');
INSERT INTO role_has_permissions VALUES('17','2');
INSERT INTO role_has_permissions VALUES('18','1');
INSERT INTO role_has_permissions VALUES('18','2');
INSERT INTO role_has_permissions VALUES('19','1');
INSERT INTO role_has_permissions VALUES('19','2');
INSERT INTO role_has_permissions VALUES('20','1');
INSERT INTO role_has_permissions VALUES('20','2');
INSERT INTO role_has_permissions VALUES('21','1');
INSERT INTO role_has_permissions VALUES('21','2');
INSERT INTO role_has_permissions VALUES('22','1');
INSERT INTO role_has_permissions VALUES('22','2');
INSERT INTO role_has_permissions VALUES('23','1');
INSERT INTO role_has_permissions VALUES('23','2');
INSERT INTO role_has_permissions VALUES('24','1');
INSERT INTO role_has_permissions VALUES('24','2');
INSERT INTO role_has_permissions VALUES('25','1');
INSERT INTO role_has_permissions VALUES('25','2');
INSERT INTO role_has_permissions VALUES('26','1');
INSERT INTO role_has_permissions VALUES('26','2');
INSERT INTO role_has_permissions VALUES('27','1');
INSERT INTO role_has_permissions VALUES('27','2');
INSERT INTO role_has_permissions VALUES('28','1');
INSERT INTO role_has_permissions VALUES('28','2');
INSERT INTO role_has_permissions VALUES('29','1');
INSERT INTO role_has_permissions VALUES('29','2');
INSERT INTO role_has_permissions VALUES('30','1');
INSERT INTO role_has_permissions VALUES('30','2');
INSERT INTO role_has_permissions VALUES('31','1');
INSERT INTO role_has_permissions VALUES('31','2');
INSERT INTO role_has_permissions VALUES('32','1');
INSERT INTO role_has_permissions VALUES('32','2');
INSERT INTO role_has_permissions VALUES('33','1');
INSERT INTO role_has_permissions VALUES('33','2');
INSERT INTO role_has_permissions VALUES('34','1');
INSERT INTO role_has_permissions VALUES('34','2');
INSERT INTO role_has_permissions VALUES('35','1');
INSERT INTO role_has_permissions VALUES('35','2');
INSERT INTO role_has_permissions VALUES('36','1');
INSERT INTO role_has_permissions VALUES('36','2');
INSERT INTO role_has_permissions VALUES('37','1');
INSERT INTO role_has_permissions VALUES('37','2');
INSERT INTO role_has_permissions VALUES('38','1');
INSERT INTO role_has_permissions VALUES('38','2');
INSERT INTO role_has_permissions VALUES('39','1');
INSERT INTO role_has_permissions VALUES('39','2');
INSERT INTO role_has_permissions VALUES('40','1');
INSERT INTO role_has_permissions VALUES('40','2');
INSERT INTO role_has_permissions VALUES('41','1');
INSERT INTO role_has_permissions VALUES('41','2');
INSERT INTO role_has_permissions VALUES('42','1');
INSERT INTO role_has_permissions VALUES('42','2');
INSERT INTO role_has_permissions VALUES('43','1');
INSERT INTO role_has_permissions VALUES('43','2');
INSERT INTO role_has_permissions VALUES('44','1');
INSERT INTO role_has_permissions VALUES('44','2');
INSERT INTO role_has_permissions VALUES('45','1');
INSERT INTO role_has_permissions VALUES('45','2');
INSERT INTO role_has_permissions VALUES('46','1');
INSERT INTO role_has_permissions VALUES('46','2');
INSERT INTO role_has_permissions VALUES('47','1');
INSERT INTO role_has_permissions VALUES('47','2');
INSERT INTO role_has_permissions VALUES('48','1');
INSERT INTO role_has_permissions VALUES('48','2');
INSERT INTO role_has_permissions VALUES('49','1');
INSERT INTO role_has_permissions VALUES('49','2');
INSERT INTO role_has_permissions VALUES('50','1');
INSERT INTO role_has_permissions VALUES('50','2');
INSERT INTO role_has_permissions VALUES('51','1');
INSERT INTO role_has_permissions VALUES('51','2');
INSERT INTO role_has_permissions VALUES('52','1');
INSERT INTO role_has_permissions VALUES('52','2');
INSERT INTO role_has_permissions VALUES('53','1');
INSERT INTO role_has_permissions VALUES('53','2');
INSERT INTO role_has_permissions VALUES('54','1');
INSERT INTO role_has_permissions VALUES('54','2');
INSERT INTO role_has_permissions VALUES('55','1');
INSERT INTO role_has_permissions VALUES('55','2');
INSERT INTO role_has_permissions VALUES('56','1');
INSERT INTO role_has_permissions VALUES('56','2');
INSERT INTO role_has_permissions VALUES('57','1');
INSERT INTO role_has_permissions VALUES('57','2');
INSERT INTO role_has_permissions VALUES('58','1');
INSERT INTO role_has_permissions VALUES('58','2');
INSERT INTO role_has_permissions VALUES('59','1');
INSERT INTO role_has_permissions VALUES('59','2');
INSERT INTO role_has_permissions VALUES('60','1');
INSERT INTO role_has_permissions VALUES('60','2');
INSERT INTO role_has_permissions VALUES('61','1');
INSERT INTO role_has_permissions VALUES('61','2');
INSERT INTO role_has_permissions VALUES('62','1');
INSERT INTO role_has_permissions VALUES('62','2');
INSERT INTO role_has_permissions VALUES('63','1');
INSERT INTO role_has_permissions VALUES('64','1');
INSERT INTO role_has_permissions VALUES('65','1');
INSERT INTO role_has_permissions VALUES('66','1');
INSERT INTO role_has_permissions VALUES('67','1');
INSERT INTO role_has_permissions VALUES('68','1');
INSERT INTO role_has_permissions VALUES('69','1');
INSERT INTO role_has_permissions VALUES('70','1');
INSERT INTO role_has_permissions VALUES('71','1');
INSERT INTO role_has_permissions VALUES('72','1');
INSERT INTO role_has_permissions VALUES('73','1');
INSERT INTO role_has_permissions VALUES('74','1');
INSERT INTO role_has_permissions VALUES('75','1');
INSERT INTO role_has_permissions VALUES('76','1');
INSERT INTO role_has_permissions VALUES('77','1');
INSERT INTO role_has_permissions VALUES('78','1');
INSERT INTO role_has_permissions VALUES('79','1');
INSERT INTO role_has_permissions VALUES('80','1');
INSERT INTO role_has_permissions VALUES('81','1');
INSERT INTO role_has_permissions VALUES('82','1');
INSERT INTO role_has_permissions VALUES('83','1');
INSERT INTO role_has_permissions VALUES('84','1');
INSERT INTO role_has_permissions VALUES('85','1');
INSERT INTO role_has_permissions VALUES('86','1');
INSERT INTO role_has_permissions VALUES('87','1');
INSERT INTO role_has_permissions VALUES('88','1');
INSERT INTO role_has_permissions VALUES('89','1');
INSERT INTO role_has_permissions VALUES('90','1');
INSERT INTO role_has_permissions VALUES('91','1');
INSERT INTO role_has_permissions VALUES('92','1');
INSERT INTO role_has_permissions VALUES('93','1');
INSERT INTO role_has_permissions VALUES('94','1');
INSERT INTO role_has_permissions VALUES('95','1');
INSERT INTO role_has_permissions VALUES('96','1');
INSERT INTO role_has_permissions VALUES('97','1');
INSERT INTO role_has_permissions VALUES('98','1');
INSERT INTO role_has_permissions VALUES('99','1');
INSERT INTO role_has_permissions VALUES('100','1');
INSERT INTO role_has_permissions VALUES('101','1');
INSERT INTO role_has_permissions VALUES('102','1');
INSERT INTO role_has_permissions VALUES('103','1');
INSERT INTO role_has_permissions VALUES('104','1');
INSERT INTO role_has_permissions VALUES('105','1');
INSERT INTO role_has_permissions VALUES('106','1');
INSERT INTO role_has_permissions VALUES('107','1');
INSERT INTO role_has_permissions VALUES('108','1');
INSERT INTO role_has_permissions VALUES('109','1');
INSERT INTO role_has_permissions VALUES('110','1');
INSERT INTO role_has_permissions VALUES('111','1');
INSERT INTO role_has_permissions VALUES('112','1');
INSERT INTO role_has_permissions VALUES('113','1');
INSERT INTO role_has_permissions VALUES('114','1');
INSERT INTO role_has_permissions VALUES('115','1');
INSERT INTO role_has_permissions VALUES('116','1');
INSERT INTO role_has_permissions VALUES('117','1');
INSERT INTO role_has_permissions VALUES('118','1');
INSERT INTO role_has_permissions VALUES('119','1');
INSERT INTO role_has_permissions VALUES('120','1');
INSERT INTO role_has_permissions VALUES('121','1');
INSERT INTO role_has_permissions VALUES('122','1');
INSERT INTO role_has_permissions VALUES('123','1');
INSERT INTO role_has_permissions VALUES('124','1');
INSERT INTO role_has_permissions VALUES('125','1');
INSERT INTO role_has_permissions VALUES('126','1');
INSERT INTO role_has_permissions VALUES('127','1');
INSERT INTO role_has_permissions VALUES('128','1');
INSERT INTO role_has_permissions VALUES('129','1');



DROP TABLE IF EXISTS roles;

CREATE TABLE `roles` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `guard_name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_name_guard_name_unique` (`name`,`guard_name`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO roles VALUES('1','super admin','web','2023-04-24 02:51:03','2023-04-24 02:51:03');
INSERT INTO roles VALUES('2','admin','web','2023-04-24 02:51:03','2023-04-24 02:51:03');
INSERT INTO roles VALUES('3','user','web','2023-04-24 02:51:03','2023-04-24 02:51:03');



DROP TABLE IF EXISTS settings;

CREATE TABLE `settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `value` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO settings VALUES('1','image','logo.png','','');
INSERT INTO settings VALUES('2','title','Diabetic Care Foods Pvt. Ltd. | Diabetes-Friendly Low Gi Foods| Manage Diabetes with Healthy Eating','','');
INSERT INTO settings VALUES('3','seo_meta_keywords','Diabetes-friendly foods, Diabetes diet, Diabetic recipes, Meal plans for diabetes, Managing diabetes with diet, Healthy eating for diabeticsdiabetes-friendly foods, Diabetes diet, Diabetic recipes, Meal plans for diabetes, Managing diabetes with diet, Healthy eating for diabetics','','');
INSERT INTO settings VALUES('4','seo_meta_description','Discover a variety of diabetes-friendly foods, recipes, meal plans, and valuable tips to effectively manage diabetes through healthy eating. Explore delicious diabetic recipes, learn about balanced meal plans, and find expert advice on maintaining stable blood sugar levels. Improve your overall health and well-being with our comprehensive resources for diabetes management through nutrition.Discover a variety of diabetes-friendly foods, recipes, meal plans, and valuable tips to effectively manage diabetes through healthy eating. Explore delicious diabetic recipes, learn about balanced meal plans, and find expert advice on maintaining stable blood sugar levels. Improve your overall health and well-being with our comprehensive resources for diabetes management through nutrition.','','');
INSERT INTO settings VALUES('5','logo','logo.png','','');
INSERT INTO settings VALUES('6','mobile_phone_first','9880227545','','');
INSERT INTO settings VALUES('7','email','info@diabeticcarefoods.com.np','','');
INSERT INTO settings VALUES('8','address','Balwatar, Kathmandu, Nepal','','');
INSERT INTO settings VALUES('9','about_summary','At Diabliss, we know that living with diabetes can be challenging. That\'s why we\'ve carefully created our products to meet your specific needs. Our wide range includes tasty and nutritious food items & beverages that are not only low in glycemic index but also packed with delicious flavors.','','');
INSERT INTO settings VALUES('10','facebook','https://www.facebook.com/diablissnepal/','','');
INSERT INTO settings VALUES('11','youtube','#','','');
INSERT INTO settings VALUES('12','tiktok','#','','');
INSERT INTO settings VALUES('13','instagram','#','','');
INSERT INTO settings VALUES('14','linkedin','#','','');
INSERT INTO settings VALUES('15','whatsapp_number','#','','');
INSERT INTO settings VALUES('16','viber_number','#','','');
INSERT INTO settings VALUES('17','from_name','Diabliss Food Care','','');
INSERT INTO settings VALUES('18','from_email','info@diabeticcarefoods.com.np','','');
INSERT INTO settings VALUES('19','mail_type','smtp','','');
INSERT INTO settings VALUES('20','smtp_host','mail.diabeticcarefoods.com.np','','');
INSERT INTO settings VALUES('21','smtp_port','465','','');
INSERT INTO settings VALUES('22','smtp_username','info@diabeticcarefoods.com.np','','');
INSERT INTO settings VALUES('23','smtp_password','.iWEQRAhD[b@','','');
INSERT INTO settings VALUES('24','smtp_encryption','ssl','','');
INSERT INTO settings VALUES('25','time','Sun - Fri: 10:00 - 18:00','','');
INSERT INTO settings VALUES('26','white-logo','whitelogo.png','','');
INSERT INTO settings VALUES('27','about_title','Our knowledgeable team can help you design an experience tailored to your needs','','');
INSERT INTO settings VALUES('28','about_image','about-us.jpg','','');
INSERT INTO settings VALUES('29','google_map','https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d56513.508114738106!2d85.25939876866939!3d27.71437589384127!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x39eb1979f2bbb909%3A0x733ea26029a5c4f8!2sDiabetic%20Care%20Foods%20Pvt.%20Ltd.!5e0!3m2!1sen!2snp!4v1683436361565!5m2!1sen!2snp','','');



DROP TABLE IF EXISTS shops;

CREATE TABLE `shops` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `shops_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO shops VALUES('1','25151009-45c4-45b0-b6e2-d4016f1d0038','1','Find us on Big Mart - Shop Smarter, Live Better','08570c2b-c75b-49b9-b011-e24933c93306.webp','1','2023-05-13 09:24:08','2023-05-21 15:18:07','');
INSERT INTO shops VALUES('2','8fe23c5e-ccbe-487c-b7aa-00ca1f3a62c2','1','Find us on Daraz','b5375ab5-1be8-4efa-aca4-1449262e8f22.webp','1','2023-05-13 09:37:00','2023-05-21 15:17:44','https://www.daraz.com.np/shop/diabetic-care-food-pvt-ltd');
INSERT INTO shops VALUES('3','dc72c4a4-67d5-45d3-91ca-b702154e2780','1','Bhat Bhateni Supermarket | Diabliss products on Bhat Bhateni Supermarket |','7d2357b3-c1a4-4467-96d0-b701d7b46d6f.webp','1','2023-05-17 15:42:51','2023-05-21 15:17:32','');
INSERT INTO shops VALUES('4','f29b33b0-42af-425a-954e-3b7ebdee1b91','1','Ktm fresh | Diabliss products available','2e9e55c1-886a-4a4a-9a06-c0886303499a.webp','1','2023-05-17 15:48:57','2023-05-21 15:17:20','');
INSERT INTO shops VALUES('5','484daf83-06c3-4278-992b-2f2b39169c7a','1','Mero kirana | Diabliss products available','50bc5641-9475-4e4a-9249-8d79ce3911aa.webp','1','2023-05-17 15:50:29','2023-05-21 15:17:05','');
INSERT INTO shops VALUES('6','380d780c-472f-4127-80f4-aa198f1fcf97','1','Find us on neeket & brothers | Diabliss products','b04ce4bd-be3a-41b4-9798-d60e51014fe8.webp','1','2023-05-17 15:56:23','2023-05-21 15:16:55','');
INSERT INTO shops VALUES('7','54e63891-ffcd-43b7-8ba9-3f293303c119','1','Find us on Nina & hager Grocer | Diabliss products','2dcee1f5-7fbe-4e07-9c1e-eb65778ed4de.webp','1','2023-05-17 15:58:10','2023-05-21 15:16:36','');



DROP TABLE IF EXISTS sliders;

CREATE TABLE `sliders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sliders_slug_unique` (`slug`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS subscribers;

CREATE TABLE `subscribers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscribers_slug_unique` (`slug`),
  UNIQUE KEY `subscribers_email_unique` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;




DROP TABLE IF EXISTS testimonials;

CREATE TABLE `testimonials` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `message` longtext NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `testimonials_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO testimonials VALUES('1','1c009da7-2a55-4ca9-b1fd-940a8b198d00','1','Sean parker','Diabliss has transformed my diabetic journey in the most positive way. Their products have become an integral part of my daily routine. Not only are they diabetic-friendly, but they also provide a much-needed burst of flavor and satisfaction. It\'s refreshing to see a brand that truly understands the needs and challenges of people with diabetes. Diabliss has made it easier for me to stay on track and live a healthier, happier life.','c76fd6b1-9764-4a55-b31a-285781dd72df.jpg','1','2023-05-10 17:32:01','2023-05-17 15:14:11');
INSERT INTO testimonials VALUES('2','ef1ecc60-2007-40ee-b953-b983ddd0648a','1','Monika Adhikari','I\'ve been using Diabliss products for a while now, and I must say they are a game-changer for me as a diabetic. Their diabetic-friendly formulations, coupled with natural ingredients, have made managing my blood sugar levels easier. Not only do their products meet my dietary needs, but they also taste great, which is a bonus. I appreciate Diabliss\' commitment to providing healthier options for individuals like me, and I highly recommend their products.','95d44fea-689f-4cc9-9a1c-20e161435144.png','1','2023-05-12 04:08:11','2023-05-17 15:59:43');
INSERT INTO testimonials VALUES('3','46ec3f8c-ac90-4140-83f3-11feb103df70','1','Nisha Karki','I\'ve been using Diabliss products for a while now, and I must say they are a game-changer for me as a diabetic. Their diabetic-friendly formulations, coupled with natural ingredients, have made managing my blood sugar levels easier. Not only do their products meet my dietary needs, but they also taste great, which is a bonus. I appreciate Diabliss\' commitment to providing healthier options for individuals like me, and I highly recommend their products.','5853d842-e253-40d7-997e-773a3e99cdcf.jpeg','1','2023-05-12 04:11:21','2023-05-17 15:11:47');



DROP TABLE IF EXISTS units;

CREATE TABLE `units` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `title` varchar(255) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `units_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO units VALUES('1','18c2dc61-7e1d-42f8-b182-be922b08ade4','1','gm','0','2023-05-10 10:24:41','2023-05-10 10:26:33');
INSERT INTO units VALUES('2','33a8a468-f12b-48c6-985c-f9f75077066d','1','kg','0','2023-05-13 04:47:29','2023-05-13 04:47:29');



DROP TABLE IF EXISTS users;

CREATE TABLE `users` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) NOT NULL,
  `remember_token` varchar(100) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO users VALUES('1','Admin','email@appmero.com','2023-04-24 02:51:03','$2y$10$MqzEiscJEWvavv7GC77nPOF21bfN7ZSU0g7aUVFtPfGb500G8EyzW','gS0vqo1SnkOWwEHGhJ2DmI4P5nWKKEsGAmZT0bQXNMVzKEkHBWStv3Kl3cxc','2023-04-24 02:51:03','2023-08-12 18:05:30');



