"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = void 0;

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _paginator = _interopRequireDefault(require("paginator"));

var _Page = _interopRequireDefault(require("./Page"));

var _classnames = _interopRequireDefault(require("classnames"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var Pagination =
/*#__PURE__*/
function (_React$Component) {
  _inherits(Pagination, _React$Component);

  function Pagination() {
    _classCallCheck(this, Pagination);

    return _possibleConstructorReturn(this, _getPrototypeOf(Pagination).apply(this, arguments));
  }

  _createClass(Pagination, [{
    key: "isFirstPageVisible",
    value: function isFirstPageVisible(has_previous_page) {
      var _this$props = this.props,
          hideDisabled = _this$props.hideDisabled,
          hideNavigation = _this$props.hideNavigation,
          hideFirstLastPages = _this$props.hideFirstLastPages;
      if (hideFirstLastPages || hideDisabled && !has_previous_page) return false;
      return true;
    }
  }, {
    key: "isPrevPageVisible",
    value: function isPrevPageVisible(has_previous_page) {
      var _this$props2 = this.props,
          hideDisabled = _this$props2.hideDisabled,
          hideNavigation = _this$props2.hideNavigation;
      if (hideNavigation || hideDisabled && !has_previous_page) return false;
      return true;
    }
  }, {
    key: "isNextPageVisible",
    value: function isNextPageVisible(has_next_page) {
      var _this$props3 = this.props,
          hideDisabled = _this$props3.hideDisabled,
          hideNavigation = _this$props3.hideNavigation;
      if (hideNavigation || hideDisabled && !has_next_page) return false;
      return true;
    }
  }, {
    key: "isLastPageVisible",
    value: function isLastPageVisible(has_next_page) {
      var _this$props4 = this.props,
          hideDisabled = _this$props4.hideDisabled,
          hideNavigation = _this$props4.hideNavigation,
          hideFirstLastPages = _this$props4.hideFirstLastPages;
      if (hideFirstLastPages || hideDisabled && !has_next_page) return false;
      return true;
    }
  }, {
    key: "buildPages",
    value: function buildPages() {
      var pages = [];
      var _this$props5 = this.props,
          itemsCountPerPage = _this$props5.itemsCountPerPage,
          pageRangeDisplayed = _this$props5.pageRangeDisplayed,
          activePage = _this$props5.activePage,
          prevPageText = _this$props5.prevPageText,
          nextPageText = _this$props5.nextPageText,
          firstPageText = _this$props5.firstPageText,
          lastPageText = _this$props5.lastPageText,
          totalItemsCount = _this$props5.totalItemsCount,
          onChange = _this$props5.onChange,
          activeClass = _this$props5.activeClass,
          itemClass = _this$props5.itemClass,
          itemClassFirst = _this$props5.itemClassFirst,
          itemClassPrev = _this$props5.itemClassPrev,
          itemClassNext = _this$props5.itemClassNext,
          itemClassLast = _this$props5.itemClassLast,
          activeLinkClass = _this$props5.activeLinkClass,
          disabledClass = _this$props5.disabledClass,
          hideDisabled = _this$props5.hideDisabled,
          hideNavigation = _this$props5.hideNavigation,
          linkClass = _this$props5.linkClass,
          linkClassFirst = _this$props5.linkClassFirst,
          linkClassPrev = _this$props5.linkClassPrev,
          linkClassNext = _this$props5.linkClassNext,
          linkClassLast = _this$props5.linkClassLast,
          hideFirstLastPages = _this$props5.hideFirstLastPages,
          getPageUrl = _this$props5.getPageUrl;
      var paginationInfo = new _paginator["default"](itemsCountPerPage, pageRangeDisplayed).build(totalItemsCount, activePage);

      for (var i = paginationInfo.first_page; i <= paginationInfo.last_page; i++) {
        pages.push(_react["default"].createElement(_Page["default"], {
          isActive: i === activePage,
          key: i,
          href: getPageUrl(i),
          pageNumber: i,
          pageText: i + "",
          onClick: onChange,
          itemClass: itemClass,
          linkClass: linkClass,
          activeClass: activeClass,
          activeLinkClass: activeLinkClass,
          ariaLabel: "Go to page number ".concat(i)
        }));
      }

      this.isPrevPageVisible(paginationInfo.has_previous_page) && pages.unshift(_react["default"].createElement(_Page["default"], {
        key: "prev" + paginationInfo.previous_page,
        href: getPageUrl(paginationInfo.previous_page),
        pageNumber: paginationInfo.previous_page,
        onClick: onChange,
        pageText: prevPageText,
        isDisabled: !paginationInfo.has_previous_page,
        itemClass: (0, _classnames["default"])(itemClass, itemClassPrev),
        linkClass: (0, _classnames["default"])(linkClass, linkClassPrev),
        disabledClass: disabledClass,
        ariaLabel: "Go to previous page"
      }));
      this.isFirstPageVisible(paginationInfo.has_previous_page) && pages.unshift(_react["default"].createElement(_Page["default"], {
        key: "first",
        href: getPageUrl(1),
        pageNumber: 1,
        onClick: onChange,
        pageText: firstPageText,
        isDisabled: !paginationInfo.has_previous_page,
        itemClass: (0, _classnames["default"])(itemClass, itemClassFirst),
        linkClass: (0, _classnames["default"])(linkClass, linkClassFirst),
        disabledClass: disabledClass,
        ariaLabel: "Go to first page"
      }));
      this.isNextPageVisible(paginationInfo.has_next_page) && pages.push(_react["default"].createElement(_Page["default"], {
        key: "next" + paginationInfo.next_page,
        href: getPageUrl(paginationInfo.next_page),
        pageNumber: paginationInfo.next_page,
        onClick: onChange,
        pageText: nextPageText,
        isDisabled: !paginationInfo.has_next_page,
        itemClass: (0, _classnames["default"])(itemClass, itemClassNext),
        linkClass: (0, _classnames["default"])(linkClass, linkClassNext),
        disabledClass: disabledClass,
        ariaLabel: "Go to next page"
      }));
      this.isLastPageVisible(paginationInfo.has_next_page) && pages.push(_react["default"].createElement(_Page["default"], {
        key: "last",
        href: getPageUrl(paginationInfo.total_pages),
        pageNumber: paginationInfo.total_pages,
        onClick: onChange,
        pageText: lastPageText,
        isDisabled: paginationInfo.current_page === paginationInfo.total_pages,
        itemClass: (0, _classnames["default"])(itemClass, itemClassLast),
        linkClass: (0, _classnames["default"])(linkClass, linkClassLast),
        disabledClass: disabledClass,
        ariaLabel: "Go to last page"
      }));
      return pages;
    }
  }, {
    key: "render",
    value: function render() {
      var pages = this.buildPages();
      return _react["default"].createElement("ul", {
        className: this.props.innerClass
      }, pages);
    }
  }]);

  return Pagination;
}(_react["default"].Component);

exports["default"] = Pagination;

_defineProperty(Pagination, "propTypes", {
  totalItemsCount: _propTypes["default"].number.isRequired,
  onChange: _propTypes["default"].func.isRequired,
  activePage: _propTypes["default"].number,
  itemsCountPerPage: _propTypes["default"].number,
  pageRangeDisplayed: _propTypes["default"].number,
  prevPageText: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].element]),
  nextPageText: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].element]),
  lastPageText: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].element]),
  firstPageText: _propTypes["default"].oneOfType([_propTypes["default"].string, _propTypes["default"].element]),
  disabledClass: _propTypes["default"].string,
  hideDisabled: _propTypes["default"].bool,
  hideNavigation: _propTypes["default"].bool,
  innerClass: _propTypes["default"].string,
  itemClass: _propTypes["default"].string,
  itemClassFirst: _propTypes["default"].string,
  itemClassPrev: _propTypes["default"].string,
  itemClassNext: _propTypes["default"].string,
  itemClassLast: _propTypes["default"].string,
  linkClass: _propTypes["default"].string,
  activeClass: _propTypes["default"].string,
  activeLinkClass: _propTypes["default"].string,
  linkClassFirst: _propTypes["default"].string,
  linkClassPrev: _propTypes["default"].string,
  linkClassNext: _propTypes["default"].string,
  linkClassLast: _propTypes["default"].string,
  hideFirstLastPages: _propTypes["default"].bool,
  getPageUrl: _propTypes["default"].func
});

_defineProperty(Pagination, "defaultProps", {
  itemsCountPerPage: 10,
  pageRangeDisplayed: 5,
  activePage: 1,
  prevPageText: "⟨",
  firstPageText: "«",
  nextPageText: "⟩",
  lastPageText: "»",
  innerClass: "pagination",
  itemClass: undefined,
  linkClass: undefined,
  activeLinkClass: undefined,
  hideFirstLastPages: false,
  getPageUrl: function getPageUrl(i) {
    return "#";
  }
});