<?php

namespace Database\Seeders;

use DB;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;

class ServiceTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // resets the users table
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('services')->truncate();
        $services = [
            [
                'slug' => Str::uuid(),
                'user_id' => 1,
                'title' => 'Polisher',
                'summary' => 'This powerful cleaner effectively removes dirt, grime, and brake dust, leaving your tires looking spotless and shiny.',
                'image_white' => 'p1.png',
                'image_dark' => '',
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'slug' => Str::uuid(),
                'user_id' => 1,
                'title' => 'Wheel Cleaner',
                'summary' => 'This powerful cleaner effectively removes dirt, grime, and brake dust, leaving your tires looking spotless and shiny.',
                'image_white' => 'p2.png',
                'image_dark' => '',
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'slug' => Str::uuid(),
                'user_id' => 1,
                'title' => 'Super Foam',
                'summary' => 'This powerful cleaner effectively removes dirt, grime, and brake dust, leaving your tires looking spotless and shiny.',
                'image_white' => 'p3.png',
                'image_dark' => '',
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'slug' => Str::uuid(),
                'user_id' => 1,
                'title' => 'Tire Cleaner',
                'summary' => 'This powerful cleaner effectively removes dirt, grime, and brake dust, leaving your tires looking spotless and shiny.',
                'image_white' => 'p1.png',
                'image_dark' => '',
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'slug' => Str::uuid(),
                'user_id' => 1,
                'title' => 'Polisher',
                'summary' => 'This powerful cleaner effectively removes dirt, grime, and brake dust, leaving your tires looking spotless and shiny.',
                'image_white' => 'p1.png',
                'image_dark' => '',
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'slug' => Str::uuid(),
                'user_id' => 1,
                'title' => 'Super Foam',
                'summary' => 'This powerful cleaner effectively removes dirt, grime, and brake dust, leaving your tires looking spotless and shiny.',
                'image_white' => 'p3.png',
                'image_dark' => '',
                'status' => 1,
                'created_at' => now(),
                'updated_at' => now()
            ],
        ];

        DB::table('services')->insert($services);
    }
}
