<?php

namespace Database\Seeders;

use DB;
use Illuminate\Support\Str;
use Illuminate\Database\Seeder;

class BannerTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // resets the users table
        DB::statement('SET FOREIGN_KEY_CHECKS=0');
        DB::table('sliders')->truncate();
        $banners = [
            [
                'slug' => Str::uuid(),
                'user_id' => 1,
                'title' => 'Car Wash banner of CleanX',
                'status' => 1,
                'image' => 'Cover-CleanX2.png',
                'created_at' => now(),
                'updated_at' => now()
            ],
            [
                'slug' => Str::uuid(),
                'user_id' => 1,
                'title' => 'CleanX official banner',
                'status' => 1,
                'image' => 'img6.webp',
                'created_at' => now(),
                'updated_at' => now()
            ]
        ];

        DB::table('sliders')->insert($banners);
    }
}
