<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    public function brand()
    {
        return $this->belongsTo(Brand::class, 'brand_id');
    }

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function scopeFilter($query, $filter)
    {
        if (isset($filter['query']) && $term = $filter['query']) {
            $query->where(function($q) use ($term, $filter) {

                $q->orWhereHas('category', function($qr) use ($term) {
                      $qr->where('title', 'LIKE', "%{$term}%");
                });
                $q->orWhereHas('brand', function($qr) use ($term) {
                    $qr->where('title', 'LIKE', "%{$term}%");
              });
                $q->orWhere('title', 'LIKE', "%{$term}%");
                $q->orWhere('description', 'LIKE', "%{$term}%");
            });
        }
    }

    public function getImageUrlAttribute($value)
    {
        $imageUrl = null;

        if ( ! is_null($this->image))
        {
            $directory = '/frontend/images/products/';
            $imagePath = public_path() . "{$directory}" . $this->image;
            if (file_exists($imagePath)) $imageUrl = asset("$directory" . $this->image);
        }

        return $imageUrl;
    }

    public function getRouteKeyName()
    {
        return 'slug';
    }
}
