<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Page extends Model
{
    use HasFactory;

    public function getImageUrlAttribute($value)
    {
        $imageUrl = null;

        if ( ! is_null($this->image))
        {
            $directory = '/frontend/images/icons/';
            $imagePath = public_path() . "{$directory}" . $this->image;
            if (file_exists($imagePath)) $imageUrl = asset("$directory" . $this->image);
        }

        return $imageUrl;
    }

    public function getRouteKeyName()
    {
        return 'slug';
    }
}
