<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DealerRequest extends Model
{
    use HasFactory;

    public function getPanFileUrlAttribute($value)
    {
        $imageUrl = null;

        if ( ! is_null($this->pan_file))
        {
            $directory = '/frontend/images/dealers/';
            $imagePath = public_path() . "{$directory}" . $this->pan_file;
            if (file_exists($imagePath)) $imageUrl = asset("$directory" . $this->pan_file);
        }

        return $imageUrl;
    }

    public function getRouteKeyName()
    {
        return 'slug';
    }
}
