<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Candidate extends Model
{
    use HasFactory;

    public function getResumeUrlAttribute($value)
    {
        $imageUrl = null;

        if ( ! is_null($this->resume))
        {
            $directory = '/frontend/images/resumes/';
            $imagePath = public_path() . "{$directory}" . $this->resume;
            if (file_exists($imagePath)) $imageUrl = asset("$directory" . $this->resume);
        }

        return $imageUrl;
    }

    public function getRouteKeyName()
    {
        return 'slug';
    }
}
