<?php

namespace App\Mail\Admin;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CustomerCareMail extends Mailable
{
    use Queueable, SerializesModels;

    public $name;
    public $email;
    public $phone;
    public $address;
    public $productName;
    public $category;
    public $dateOfPurchase;
    public $complainType;
    public $remarks;
    public $warrentyCard;
    public $billingCard;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($name, $email, $phone, $address, $productName, $category, $dateOfPurchase, $complainType, $remarks, $warrentyCard, $billingCard)
    {
        $this->name = $name;
        $this->email = $email;
        $this->phone = $phone;
        $this->address = $address;
        $this->productName = $productName;
        $this->category = $category;
        $this->dateOfPurchase = $dateOfPurchase;
        $this->complainType = $complainType;
        $this->remarks = $remarks;
        $this->warrentyCard = $warrentyCard;
        $this->billingCard = $billingCard;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->markdown('emails.admin.customer-care-mail')
                    ->subject('New Contact Enquiry Notification');
    }
}
